/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import com.shynieke.statues.blocks.AbstractStatueBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractStatueBlockEntity
extends BlockEntity {
    public static int cooldown;
    public static int cooldownMax;
    public static boolean statueAble;
    private static int mobKilled;
    private static int statueLevel;
    private static boolean dropsItems;
    private static float dropMultiplier;
    private static boolean spawnsMobs;
    private static boolean makesSounds;
    private static boolean hasExternalUse;

    protected AbstractStatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
        cooldown = 0;
        statueAble = false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        cooldown = compound.m_128451_("StatueCooldown");
        cooldownMax = compound.m_128451_("StatueMaxcooldown");
        statueAble = compound.m_128471_("StatueAble");
        this.loadFromNbt(compound);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128405_("StatueCooldown", cooldown);
        compound.m_128405_("StatueMaxcooldown", cooldownMax);
        compound.m_128379_("StatueAble", statueAble);
        return this.saveToNbt(compound);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 0, this.m_5995_());
    }

    public int getCooldown() {
        return cooldown;
    }

    public int getCooldownMax() {
        return cooldownMax;
    }

    public int getStatueLevel() {
        return statueLevel;
    }

    public float getDropMultiplier() {
        return dropMultiplier;
    }

    public boolean isStatueAble() {
        return statueAble;
    }

    public void setStatueAble(boolean statueAble) {
        AbstractStatueBlockEntity.statueAble = statueAble;
        this.m_6596_();
    }

    public void loadFromNbt(CompoundTag compound) {
        mobKilled = compound.m_128451_("mobKilled");
        statueLevel = compound.m_128451_("statueLevel");
        dropsItems = compound.m_128471_("dropsItems");
        spawnsMobs = compound.m_128471_("spawnsMobs");
        makesSounds = compound.m_128471_("makesSounds");
        hasExternalUse = compound.m_128471_("hasExternalUse");
        dropMultiplier = compound.m_128457_("dropMultiplier");
    }

    public CompoundTag saveToNbt(CompoundTag compound) {
        this.saveAllTraits(compound);
        return compound;
    }

    public CompoundTag saveAllTraits(CompoundTag tag) {
        ListTag listnbt = new ListTag();
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128405_("mobKilled", mobKilled);
        compoundnbt.m_128405_("statueLevel", statueLevel);
        compoundnbt.m_128379_("dropsItems", dropsItems);
        compoundnbt.m_128379_("spawnsMobs", spawnsMobs);
        compoundnbt.m_128379_("makesSounds", makesSounds);
        compoundnbt.m_128379_("hasExternalUse", hasExternalUse);
        compoundnbt.m_128350_("dropMultiplier", dropMultiplier);
        listnbt.add((Object)compoundnbt);
        if (!listnbt.isEmpty()) {
            tag.m_128365_("Traits", (Tag)listnbt);
        }
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDecorative() {
        if (dropsItems) return false;
        if (spawnsMobs) return false;
        if (makesSounds) return false;
        if (hasExternalUse) return false;
        return true;
    }

    public boolean canDropItems() {
        return dropsItems;
    }

    public boolean canSpawnMobs() {
        return spawnsMobs;
    }

    public boolean makesSounds() {
        return makesSounds;
    }

    public boolean hasExternalUse() {
        return hasExternalUse;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractStatueBlockEntity blockEntity) {
        if (state.m_60734_() instanceof AbstractStatueBase && ((Boolean)state.m_61143_((Property)AbstractStatueBase.INTERACTIVE)).booleanValue()) {
            if (!statueAble) {
                blockEntity.m_6596_();
                if (++cooldown >= cooldownMax) {
                    cooldown = 0;
                    blockEntity.setStatueAble(true);
                }
            }
        }
    }

    static {
        cooldownMax = 200;
    }
}

