/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.init.StatueBlockEntities;
import com.shynieke.statues.init.StatueRegistry;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlayerBlockEntity
extends BlockEntity
implements Nameable {
    @Nullable
    private static GameProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;
    private GameProfile playerProfile;
    private boolean comparatorApplied = false;
    private boolean onlineChecking = false;
    private int checkerCooldown = 0;

    public PlayerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StatueBlockEntities.PLAYER.get(), pos, state);
    }

    public static void setProfileCache(GameProfileCache cache) {
        profileCache = cache;
    }

    public static void setSessionService(MinecraftSessionService session) {
        sessionService = session;
    }

    public static void setMainThreadExecutor(Executor executor) {
        mainThreadExecutor = executor;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("PlayerProfile", 10)) {
            this.setPlayerProfile(NbtUtils.m_129228_((CompoundTag)compound.m_128469_("PlayerProfile")));
        }
        this.comparatorApplied = compound.m_128471_("comparatorApplied");
        this.onlineChecking = compound.m_128471_("OnlineChecking");
        this.checkerCooldown = compound.m_128451_("checkerCooldown");
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        if (this.playerProfile != null) {
            CompoundTag compoundnbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compoundnbt, (GameProfile)this.playerProfile);
            compound.m_128365_("PlayerProfile", (Tag)compoundnbt);
        }
        compound.m_128379_("comparatorApplied", this.comparatorApplied);
        compound.m_128379_("OnlineChecking", this.onlineChecking);
        compound.m_128405_("checkerCooldown", this.checkerCooldown);
        return compound;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundNBT = pkt.m_131708_();
        this.handleUpdateTag(compoundNBT);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 0, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public boolean m_8077_() {
        return this.playerProfile != null && !this.playerProfile.getName().isEmpty();
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerProfile(@Nullable GameProfile profile) {
        PlayerBlockEntity playerBlockEntity = this;
        synchronized (playerBlockEntity) {
            this.playerProfile = profile;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        PlayerBlockEntity.updateGameprofile(this.playerProfile, p_155747_ -> {
            this.playerProfile = p_155747_;
            this.m_6596_();
        });
    }

    @Nullable
    public static void updateGameprofile(@Nullable GameProfile profile, Consumer<GameProfile> profileConsumer) {
        if (!(profile == null || StringUtil.m_14408_((String)profile.getName()) || profile.isComplete() && profile.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null)) {
            profileCache.m_143967_(profile.getName(), p_182470_ -> Util.m_137578_().execute(() -> Util.m_137521_((Optional)p_182470_, p_182479_ -> {
                com.mojang.authlib.properties.Property property = (com.mojang.authlib.properties.Property)Iterables.getFirst((Iterable)p_182479_.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    p_182479_ = sessionService.fillProfileProperties(p_182479_, true);
                }
                GameProfile gameprofile = p_182479_;
                mainThreadExecutor.execute(() -> {
                    profileCache.m_10991_(gameprofile);
                    profileConsumer.accept(gameprofile);
                });
            }, () -> mainThreadExecutor.execute(() -> profileConsumer.accept(profile)))));
        } else {
            profileConsumer.accept(profile);
        }
    }

    public void updateOnline() {
        boolean checkAnswer;
        BlockState state = this.m_58900_();
        boolean isStateOnline = (Boolean)state.m_61143_((Property)PlayerStatueBlock.ONLINE);
        boolean bl = checkAnswer = this.f_58857_.m_46003_(this.playerProfile.getId()) != null;
        if (isStateOnline != checkAnswer) {
            BlockState newState = (BlockState)state.m_61124_((Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(checkAnswer));
            this.f_58857_.m_46597_(this.m_58899_(), newState);
            this.f_58857_.m_7260_(this.m_58899_(), state, newState, 3);
        }
    }

    public void setComparatorApplied(boolean comparatorApplied) {
        this.comparatorApplied = comparatorApplied;
        if (!comparatorApplied) {
            BlockState state = this.m_58900_();
            BlockState newState = (BlockState)state.m_61124_((Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_46597_(this.m_58899_(), newState);
            this.f_58857_.m_7260_(this.m_58899_(), state, newState, 3);
        }
        this.m_6596_();
    }

    public boolean getComparatorApplied() {
        return this.comparatorApplied;
    }

    public int getCooldown() {
        return this.checkerCooldown;
    }

    public void setOnlineChecking(boolean onlineChecking) {
        this.onlineChecking = onlineChecking;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.m_8077_() ? new TextComponent(this.playerProfile != null ? this.playerProfile.getName() : "") : new TranslatableComponent("statue.player");
    }

    @Nullable
    public Component m_7770_() {
        return null;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PlayerBlockEntity blockEntity) {
        if (level != null && state.m_60713_((Block)StatueRegistry.PLAYER_STATUE.get()) && blockEntity.comparatorApplied) {
            if (!blockEntity.onlineChecking) {
                ++blockEntity.checkerCooldown;
                blockEntity.m_6596_();
                if (blockEntity.checkerCooldown == 0) {
                    blockEntity.checkerCooldown = 200;
                }
                if (blockEntity.checkerCooldown >= 200) {
                    blockEntity.checkerCooldown = 0;
                    blockEntity.setOnlineChecking(true);
                }
            } else {
                blockEntity.updateOnline();
                blockEntity.setOnlineChecking(false);
            }
        }
    }
}

