/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import com.shynieke.statues.init.StatueBlockEntities;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.recipes.LootInfo;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.AbstractStatueBlockEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StatueBlockEntity
extends AbstractStatueBlockEntity {
    public static final int[] DYE_COLORS = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public StatueBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)StatueBlockEntities.STATUE.get(), pos, state);
    }

    public StatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public void playSound(SoundEvent sound, BlockPos pos) {
        this.playSound(sound, pos, 1.0f);
    }

    public void playSound(SoundEvent sound, BlockPos pos, float pitch) {
        if (this.makesSounds()) {
            this.f_58857_.m_5594_(null, pos, sound, SoundSource.NEUTRAL, 1.0f, pitch);
        }
    }

    public void giveItem(LootInfo loot, Player playerIn) {
        if (this.f_58857_ != null && this.isStatueAble()) {
            int random = this.f_58857_.f_46441_.nextInt(100);
            if (!this.isDecorative() && loot.hasLoot()) {
                ItemStack stack1 = loot.getStack1();
                ItemStack stack2 = loot.getStack2();
                ItemStack stack3 = loot.getStack3();
                if (stack1 != null && stack1 != ItemStack.f_41583_) {
                    playerIn.m_36176_(stack1, true);
                }
                if (stack2 != null && stack2 != ItemStack.f_41583_ && random <= 50) {
                    playerIn.m_36176_(stack2, true);
                }
                if (stack3 != null && stack3 != ItemStack.f_41583_ && random <= 10) {
                    playerIn.m_36176_(stack3, true);
                }
                this.setStatueAble(false);
            }
        }
    }

    public void summonMob(LivingEntity entityIn) {
        if (this.f_58857_ != null && this.canSpawnMobs()) {
            int random = this.f_58857_.f_46441_.nextInt(100);
            if (random < 1) {
                if (entityIn instanceof Rabbit) {
                    Rabbit rabbit = (Rabbit)entityIn;
                    rabbit.m_29733_(99);
                    rabbit.m_6021_((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_());
                    this.f_58857_.m_7967_((Entity)rabbit);
                } else if (entityIn instanceof Creeper) {
                    Creeper creeper = (Creeper)entityIn;
                    creeper.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, 0.0f, 0.0f);
                    CompoundTag tag = new CompoundTag();
                    creeper.m_7380_(tag);
                    tag.m_128376_("ExplosionRadius", (short)0);
                    creeper.m_7378_(tag);
                    this.f_58857_.m_7967_((Entity)creeper);
                    creeper.m_21373_();
                } else {
                    entityIn.m_6021_((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_());
                    this.f_58857_.m_7967_((Entity)entityIn);
                }
            }
            this.setStatueAble(false);
        }
    }

    public void floodBehavior(Player playerIn, BlockPos pos, InteractionHand hand, float hitX, float hitY, float hitZ) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack stack = playerIn.m_21120_(hand);
            int random = this.f_58857_.f_46441_.nextInt(100);
            if (stack.m_41720_() == Items.f_42446_ && !playerIn.m_150110_().f_35937_) {
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                stack.m_41774_(1);
                ItemStack floodbucket = StatueLootList.getFloodBucket();
                if (stack.m_41619_()) {
                    playerIn.m_21008_(hand, floodbucket);
                } else if (!playerIn.m_150109_().m_36054_(floodbucket)) {
                    playerIn.m_36176_(floodbucket, false);
                }
            }
            if (random < 50) {
                FireworkRocketEntity firework = new FireworkRocketEntity(this.f_58857_, (double)((float)pos.m_123341_() + hitX), (double)((float)pos.m_123342_() + hitY), (double)((float)pos.m_123343_() + hitZ), this.getFirework(this.f_58857_.f_46441_));
                this.f_58857_.m_7967_((Entity)firework);
            }
        }
    }

    public void mooshroomBehavior(Player playerIn, BlockPos pos, InteractionHand hand) {
        ItemStack stack;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (stack = playerIn.m_21120_(hand)).m_41720_() == Items.f_42399_ && !playerIn.m_150110_().f_35937_) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11833_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.m_41774_(1);
            ItemStack soupStack = new ItemStack((ItemLike)StatueRegistry.SOUP.get());
            if (stack.m_41619_()) {
                playerIn.m_21008_(hand, soupStack);
            } else if (!playerIn.m_150109_().m_36054_(soupStack)) {
                playerIn.m_36176_(soupStack, false);
            }
        }
    }

    public void cowBehavior(Player playerIn, BlockPos pos, InteractionHand hand) {
        ItemStack stack;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (stack = playerIn.m_21120_(hand)).m_41720_() == Items.f_42446_ && !playerIn.m_150110_().f_35937_) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11833_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                playerIn.m_21008_(hand, new ItemStack((ItemLike)Items.f_42455_));
            } else if (!playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42455_))) {
                playerIn.m_36176_(new ItemStack((ItemLike)Items.f_42455_), false);
            }
        }
    }

    public void giveEffect(BlockPos pos, Player player, MobEffect effect) {
        if (this.isStatueAble() && this.f_58857_ != null) {
            int random = this.f_58857_.f_46441_.nextInt(100);
            if (this.hasExternalUse() && random < 10 && !this.f_58857_.f_46443_ && player.m_21124_(effect) == null) {
                player.m_7292_(new MobEffectInstance(effect, 400, 1, true, true));
            }
        }
    }

    public ItemStack getFirework(Random rand) {
        ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
        firework.m_41784_();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Flicker", true);
        nbt.m_128379_("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DYE_COLORS[rand.nextInt(16)];
        }
        nbt.m_128385_("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        nbt.m_128344_("Type", type);
        ListTag explosions = new ListTag();
        explosions.add((Object)nbt);
        CompoundTag fireworkTag = new CompoundTag();
        fireworkTag.m_128365_("Explosions", (Tag)explosions);
        fireworkTag.m_128344_("Flight", (byte)1);
        CompoundTag stackTag = firework.m_41784_();
        stackTag.m_128365_("Fireworks", (Tag)fireworkTag);
        firework.m_41751_(stackTag);
        return firework;
    }
}

