/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soulspark.tea_kettle.core.ClientEvents;
import soulspark.tea_kettle.core.CommonEvents;
import soulspark.tea_kettle.core.compat.AbundanceInteropProxy;
import soulspark.tea_kettle.core.compat.CFBInteropProxy;
import soulspark.tea_kettle.core.compat.CompatHandler;
import soulspark.tea_kettle.core.compat.SimplyTeaInteropProxy;
import soulspark.tea_kettle.core.compat.SupplementariesInteropProxy;
import soulspark.tea_kettle.core.init.ClientInitEvents;
import soulspark.tea_kettle.core.init.CommonInitEvents;
import soulspark.tea_kettle.core.init.RegistryHandler;

@Mod(value="tea_kettle")
public class TeaKettle {
    public static final String MODID = "tea_kettle";
    public static final Logger LOGGER = LogManager.getLogger();

    public TeaKettle() {
        IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        RegistryHandler.register(MOD_BUS);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> TeaKettle.registerClientEvents(MOD_BUS));
        TeaKettle.registerCommonEvents(MOD_BUS);
        if (ModList.get().isLoaded("simplytea")) {
            CompatHandler.PROXIES.add(new SimplyTeaInteropProxy());
        }
        if (ModList.get().isLoaded("abundance")) {
            CompatHandler.PROXIES.add(new AbundanceInteropProxy());
        }
        if (ModList.get().isLoaded("supplementaries")) {
            CompatHandler.PROXIES.add(new SupplementariesInteropProxy());
        }
        if (ModList.get().isLoaded("cookingforblockheads")) {
            CompatHandler.PROXIES.add(new CFBInteropProxy());
        }
    }

    public static void registerCommonEvents(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.register(CommonEvents.class);
        modBus.register(CommonInitEvents.class);
    }

    public static void registerClientEvents(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        modBus.register(ClientInitEvents.class);
    }
}

