/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import soulspark.tea_kettle.core.util.TeaKettleUtils;

public class TeaModel
implements IModelGeometry<TeaModel> {
    public static final ResourceLocation BASE_STEAM = new ResourceLocation("tea_kettle", "item/tea_steam");
    public static final ResourceLocation WEAK_STEAM = new ResourceLocation("tea_kettle", "item/tea_steam_weak");
    public static final ResourceLocation STRONG_STEAM = new ResourceLocation("tea_kettle", "item/tea_steam_strong");
    private final ResourceLocation baseLocation;
    private final ResourceLocation steamLocation;

    public TeaModel(ResourceLocation baseLocation, ResourceLocation steamLocation) {
        this.steamLocation = steamLocation;
        this.baseLocation = baseLocation;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        RenderMaterial steamTexture = new RenderMaterial(AtlasTexture.field_110575_b, this.steamLocation);
        RenderMaterial baseTexture = new RenderMaterial(AtlasTexture.field_110575_b, this.baseLocation);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(owner.getCombinedTransform(), modelTransform));
        TransformationMatrix transform = modelTransform.func_225615_b_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)spriteGetter.apply(baseTexture), (ItemOverrideList)new TeaOverrideList(owner, bakery, this), (ImmutableMap)transformMap);
        builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)baseTexture), (TransformationMatrix)transform, spriteGetter));
        builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)steamTexture), (TransformationMatrix)transform, spriteGetter));
        return builder.build();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Sets.newHashSet();
    }

    public TeaModel withSteam(ResourceLocation steamTexture) {
        return new TeaModel(this.baseLocation, steamTexture);
    }

    private static final class TeaOverrideList
    extends ItemOverrideList {
        private IBakedModel WEAK_MODEL;
        private IBakedModel STRONG_MODEL;
        private final IModelConfiguration owner;
        private final ModelBakery bakery;
        private final TeaModel parent;

        public TeaOverrideList(IModelConfiguration owner, ModelBakery bakery, TeaModel parent) {
            this.owner = owner;
            this.bakery = bakery;
            this.parent = parent;
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
            float sweetness = TeaKettleUtils.getSweetness(stack);
            if (sweetness == 0.0f) {
                return model;
            }
            if (sweetness <= 0.5f) {
                if (this.WEAK_MODEL == null) {
                    this.WEAK_MODEL = this.parent.withSteam(WEAK_STEAM).bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, this, new ResourceLocation("tea_kettle:tea_override"));
                }
                return this.WEAK_MODEL;
            }
            if (this.STRONG_MODEL == null) {
                this.STRONG_MODEL = this.parent.withSteam(STRONG_STEAM).bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, this, new ResourceLocation("tea_kettle:tea_override"));
            }
            return this.STRONG_MODEL;
        }
    }

    public static enum Loader implements IModelLoader<TeaModel>
    {
        INSTANCE;


        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public TeaModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new TeaModel(new ResourceLocation(modelContents.getAsJsonObject("textures").get("base").getAsString()), BASE_STEAM);
        }
    }
}

