/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.blocks;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import soulspark.tea_kettle.common.blocks.IGrabbable;
import soulspark.tea_kettle.common.recipes.TeaSteepingRecipe;
import soulspark.tea_kettle.common.tile_entities.CupTileEntity;
import soulspark.tea_kettle.core.init.ModBlocks;
import soulspark.tea_kettle.core.init.ModRecipeTypes;
import soulspark.tea_kettle.core.util.TeaKettleTags;

public class CupBlock
extends Block
implements IGrabbable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public CupBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        ModBlocks.CUPS.add(this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CupTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        return worldIn.func_180495_p(below).func_224755_d((IBlockReader)worldIn, below, Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof CupTileEntity)) {
            return ActionResultType.PASS;
        }
        CupTileEntity cupTileEntity = (CupTileEntity)tileEntity;
        ItemStack handStack = player.func_184586_b(handIn);
        boolean handEmpty = handStack.func_190926_b();
        if (handEmpty) {
            if (handIn == Hand.MAIN_HAND) {
                ItemStack cupStack = cupTileEntity.handler.getLastStack();
                if (cupStack.func_190926_b()) {
                    if (!worldIn.field_72995_K) {
                        ItemStack blockStack = this.getGrabStack(state, worldIn, pos);
                        if (!player.field_71075_bZ.field_75098_d) {
                            blockStack.func_190917_f(handStack.func_190916_E());
                        }
                        player.func_184611_a(handIn, blockStack);
                        ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                        worldIn.func_217377_a(pos, false);
                    } else {
                        player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
                    }
                } else {
                    player.func_184611_a(handIn, cupStack.func_77979_a(64));
                }
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
        } else if (handStack.func_77973_b().func_206844_a(TeaKettleTags.KETTLES)) {
            if (!cupTileEntity.handler.isEmpty()) {
                if (!this.tryMakeTea(state, worldIn, pos, (ItemStack[])cupTileEntity.handler.getStacks().toArray((Object[])new ItemStack[2]), handStack)) {
                    return ActionResultType.CONSUME;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(handIn, handStack.getContainerItem());
                    if (player instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                    }
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
        } else {
            ItemStack[] itemStackArray;
            ItemStack cupStack = cupTileEntity.handler.getLastStack();
            if (cupStack.func_190926_b()) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = handStack;
            } else {
                ItemStack[] itemStackArray3 = new ItemStack[2];
                itemStackArray3[0] = handStack;
                itemStackArray = itemStackArray3;
                itemStackArray3[1] = cupStack;
            }
            ItemStack[] ingredients = itemStackArray;
            if (this.isIngredient(ingredients, ModRecipeTypes.TEA_STEEPING, worldIn) || this.isIngredient(ingredients, ModRecipeTypes.MILKY_DRINK, worldIn)) {
                ItemStack copyStack = handStack.func_77946_l();
                copyStack.func_190920_e(1);
                if (cupTileEntity.handler.addStack(copyStack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        handStack.func_190918_g(1);
                        if (player instanceof ServerPlayerEntity) {
                            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                        }
                    }
                    player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
                return ActionResultType.CONSUME;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected <T extends TeaSteepingRecipe> boolean isIngredient(ItemStack[] stacks, IRecipeType<T> recipeType, World world) {
        if (stacks.length == 0) {
            return false;
        }
        if (stacks.length == 2) {
            return world.func_199532_z().func_215371_a(ModRecipeTypes.TEA_STEEPING, (IInventory)new Inventory(stacks), world).isPresent() || world.func_199532_z().func_215371_a(ModRecipeTypes.MILKY_DRINK, (IInventory)new Inventory(stacks), world).isPresent();
        }
        List recipes = world.func_199532_z().func_241447_a_(recipeType);
        return recipes.stream().anyMatch(recipe -> {
            for (ItemStack stack : stacks) {
                if (!recipe.func_192400_c().stream().noneMatch(ingredient -> ingredient.test(stack))) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public ItemStack getGrabStack(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CupTileEntity) {
            CupTileEntity cupTileEntity = (CupTileEntity)tileEntity;
            ItemStack cupStack = cupTileEntity.handler.getLastStack();
            if (!cupStack.func_190926_b()) {
                return cupStack;
            }
        }
        return new ItemStack((IItemProvider)this.func_199767_j());
    }

    @Override
    public void grab(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof CupTileEntity) || world.field_72995_K) {
            return;
        }
        CupTileEntity cupTileEntity = (CupTileEntity)tileEntity;
        ItemStack cupStack = cupTileEntity.handler.getLastStack();
        if (cupStack.func_190926_b()) {
            world.func_217377_a(pos, false);
        } else {
            cupTileEntity.handler.setLastStack(ItemStack.field_190927_a);
        }
    }

    private boolean tryMakeTea(BlockState state, World worldIn, BlockPos pos, ItemStack[] ingredients, ItemStack handStack) {
        Optional optional;
        Optional optional2 = optional = handStack.func_77973_b().func_206844_a(TeaKettleTags.BOILING_KETTLES) ? worldIn.func_199532_z().func_215371_a(ModRecipeTypes.TEA_STEEPING, (IInventory)new Inventory(ingredients), worldIn) : worldIn.func_199532_z().func_215371_a(ModRecipeTypes.MILKY_DRINK, (IInventory)new Inventory(ingredients), worldIn);
        if (optional.isPresent()) {
            TeaSteepingRecipe recipe = (TeaSteepingRecipe)optional.get();
            Item item = recipe.func_77571_b().func_77973_b();
            if (ModBlocks.TEA_ITEM_TO_BLOCK.containsKey(item.getRegistryName())) {
                item = (Item)ModBlocks.TEA_ITEM_TO_BLOCK.get(item.getRegistryName());
            }
            if (item instanceof BlockItem) {
                worldIn.func_175656_a(pos, (BlockState)((BlockItem)item).func_179223_d().func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileEntity instanceof CupTileEntity) {
            drops.addAll(((CupTileEntity)tileEntity).handler.getStacks());
        }
        return drops;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

