/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.blocks;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import soulspark.tea_kettle.common.blocks.KettleBlock;
import soulspark.tea_kettle.common.items.FilledKettleItem;
import soulspark.tea_kettle.common.tile_entities.KettleTileEntity;

public class FilledKettleBlock
extends KettleBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty HOT = BooleanProperty.func_177716_a((String)"hot");
    public static final IntegerProperty FULLNESS = IntegerProperty.func_177719_a((String)"fullness", (int)1, (int)4);
    private final Function<Boolean, Item> itemSupplier;

    public FilledKettleBlock(Function<Boolean, Item> itemSupplier, AbstractBlock.Properties builder) {
        super(builder);
        this.itemSupplier = itemSupplier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HOT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FULLNESS, (Comparable)Integer.valueOf(4)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KettleTileEntity();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(this.isHot((IWorld)context.func_195991_k(), context.func_195995_a().func_177977_b())));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (state.func_177230_c() == this) {
            return (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(this.isHot(worldIn, facingPos)));
        }
        return state;
    }

    @Override
    public ItemStack getGrabStack(BlockState state, World worldIn, BlockPos pos) {
        ItemStack kettleStack = new ItemStack((IItemProvider)this.itemSupplier.apply((Boolean)state.func_177229_b((Property)HOT)));
        kettleStack.func_77983_a("BlockEntityTag", (INBT)worldIn.func_175625_s(pos).serializeNBT());
        CompoundNBT blockStates = new CompoundNBT();
        blockStates.func_74768_a("fullness", ((Integer)state.func_177229_b((Property)FULLNESS)).intValue());
        kettleStack.func_77983_a("BlockStateTag", (INBT)blockStates);
        return kettleStack;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        for (ItemStack drop : drops) {
            if (!(drop.func_77973_b() instanceof FilledKettleItem)) continue;
            CompoundNBT tag = drop.func_196082_o();
            CompoundNBT blockStateTag = tag.func_74775_l("BlockStateTag");
            blockStateTag.func_74768_a("fullness", ((Integer)state.func_177229_b((Property)FULLNESS)).intValue());
            tag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
        }
        return drops;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT, HOT, FULLNESS});
    }
}

