/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import soulspark.tea_kettle.common.blocks.IGrabbable;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.util.TeaKettleTags;

public class KettleBlock
extends Block
implements IGrabbable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public KettleBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean isHot(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_235714_a_(TeaKettleTags.HOT) || (state.func_235714_a_(TeaKettleTags.FURNACES) || state.func_177230_c() instanceof AbstractFurnaceBlock) && (Boolean)state.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b) != false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        return worldIn.func_180495_p(below).func_224755_d((IBlockReader)worldIn, below, Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(handIn);
        if (itemStack.func_190926_b() && handIn == Hand.MAIN_HAND) {
            if (!worldIn.field_72995_K) {
                ItemStack stack = this.getGrabStack(state, worldIn, pos);
                player.func_184611_a(handIn, stack);
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                }
                worldIn.func_217377_a(pos, false);
            } else {
                player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public ItemStack getGrabStack(BlockState state, World worldIn, BlockPos pos) {
        return new ItemStack((IItemProvider)ModItems.EMPTY_KETTLE.get());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

