/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.blocks;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import soulspark.tea_kettle.common.blocks.CupBlock;
import soulspark.tea_kettle.common.blocks.IGrabbable;
import soulspark.tea_kettle.common.recipes.TeaMixingRecipe;
import soulspark.tea_kettle.core.init.ModBlocks;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.init.ModParticles;
import soulspark.tea_kettle.core.init.ModRecipeTypes;
import soulspark.tea_kettle.core.util.TeaKettleTags;

public class TeaBlock
extends Block
implements IGrabbable {
    public static final DirectionProperty FACING = CupBlock.FACING;
    public static final IntegerProperty SWEETNESS = IntegerProperty.func_177719_a((String)"sweetness", (int)0, (int)2);

    public TeaBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)SWEETNESS, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CupBlock.SHAPE;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        return worldIn.func_180495_p(below).func_224755_d((IBlockReader)worldIn, below, Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int sweetenerFactor;
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_190926_b() && handIn == Hand.MAIN_HAND) {
            if (!worldIn.field_72995_K) {
                ItemStack teaStack = this.getGrabStack(state, worldIn, pos);
                if (stack.func_190926_b()) {
                    player.func_184611_a(handIn, teaStack);
                }
                ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                this.grab(worldIn, pos);
            } else {
                player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (stack.func_77973_b().func_206844_a(TeaKettleTags.FROTHING_KETTLES)) {
            if (!this.tryMix(state, worldIn, pos)) {
                return ActionResultType.CONSUME;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(handIn, stack.getContainerItem());
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                }
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 0.8f, 0.9f);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        int n = stack.func_77973_b().func_206844_a(TeaKettleTags.STRONG_SWEENETERS) ? 2 : (sweetenerFactor = stack.func_77973_b().func_206844_a(TeaKettleTags.WEAK_SWEENETERS) ? 1 : 0);
        if (sweetenerFactor > (Integer)state.func_177229_b((Property)SWEETNESS)) {
            if (!worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack returnStack = stack.getContainerItem();
                    if (stack.func_77973_b() == Items.field_226638_pX_) {
                        returnStack = new ItemStack((IItemProvider)ModItems.HALF_HONEY_BOTTLE.get());
                    }
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.func_184611_a(handIn, returnStack);
                    } else {
                        player.func_191521_c(returnStack);
                    }
                    if (player instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                    }
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SWEETNESS, (Comparable)Integer.valueOf(sweetenerFactor)));
                worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 0.8f, 0.9f);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public ItemStack getGrabStack(BlockState state, World world, BlockPos pos) {
        ItemStack teaStack = new ItemStack((IItemProvider)this.func_199767_j());
        CompoundNBT tag = teaStack.func_196082_o();
        CompoundNBT blockStateTag = tag.func_74775_l("BlockStateTag");
        blockStateTag.func_74778_a("sweetness", ((Integer)state.func_177229_b((Property)SWEETNESS)).toString());
        tag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
        teaStack.func_77982_d(tag);
        return teaStack;
    }

    private boolean tryMix(BlockState state, World worldIn, BlockPos pos) {
        Optional optional = worldIn.func_199532_z().func_215371_a(ModRecipeTypes.TEA_MIXING, (IInventory)new Inventory(new ItemStack[]{new ItemStack((IItemProvider)this.func_199767_j())}), worldIn);
        if (optional.isPresent()) {
            TeaMixingRecipe recipe = (TeaMixingRecipe)optional.get();
            Item item = recipe.func_77571_b().func_77973_b();
            if (ModBlocks.TEA_ITEM_TO_BLOCK.containsKey(item.getRegistryName())) {
                item = (Item)ModBlocks.TEA_ITEM_TO_BLOCK.get(item.getRegistryName());
            }
            if (item instanceof BlockItem) {
                worldIn.func_175656_a(pos, (BlockState)((BlockState)((BlockItem)item).func_179223_d().func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)SWEETNESS, state.func_177229_b((Property)SWEETNESS)));
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        for (ItemStack drop : drops) {
            if (drop.func_77973_b() != this.func_199767_j()) continue;
            CompoundNBT tag = drop.func_196082_o();
            CompoundNBT blockStateTag = tag.func_74775_l("BlockStateTag");
            blockStateTag.func_74778_a("sweetness", ((Integer)state.func_177229_b((Property)SWEETNESS)).toString());
            tag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
        }
        return drops;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int sweetness = (Integer)stateIn.func_177229_b((Property)SWEETNESS);
        BasicParticleType particleData = (BasicParticleType)ModParticles.TEA_STEAM.get();
        switch (sweetness) {
            case 1: {
                particleData = (BasicParticleType)ModParticles.WEAK_TEA_STEAM.get();
                break;
            }
            case 2: {
                particleData = (BasicParticleType)ModParticles.STRONG_TEA_STEAM.get();
            }
        }
        if (rand.nextFloat() < 0.5f) {
            worldIn.func_195590_a((IParticleData)particleData, true, (double)((float)pos.func_177958_n() + this.randomSteamPos(rand)), (double)pos.func_177956_o() + 0.3125, (double)((float)pos.func_177952_p() + this.randomSteamPos(rand)), 0.0, 0.0, 0.0);
        }
        worldIn.func_195590_a((IParticleData)particleData, true, (double)((float)pos.func_177958_n() + this.randomSteamPos(rand)), (double)pos.func_177956_o() + 0.3125, (double)((float)pos.func_177952_p() + this.randomSteamPos(rand)), 0.0, 0.0, 0.0);
    }

    private float randomSteamPos(Random rand) {
        return 0.425f + rand.nextFloat() * 0.15f;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SWEETNESS});
    }
}

