/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import soulspark.tea_kettle.common.blocks.KettleBlock;
import soulspark.tea_kettle.common.items.KettleItem;
import soulspark.tea_kettle.core.init.ModItems;

public class EmptyKettleItem
extends KettleItem {
    public EmptyKettleItem(KettleBlock block, Item.Properties builder) {
        super(block, builder);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResult<ItemStack> result;
        if (context.func_195999_j() != null && (result = this.tryCollectWater(context.func_195991_k(), context.func_195999_j(), context.func_221531_n())).func_188397_a().func_226246_a_()) {
            ItemStack stack = context.func_195996_i();
            ItemStack returnStack = (ItemStack)result.func_188398_b();
            PlayerEntity player = context.func_195999_j();
            returnStack = this.fillKettle(stack.func_77946_l(), player, returnStack);
            player.func_184611_a(context.func_221531_n(), returnStack);
            return result.func_188397_a();
        }
        return super.func_195939_a(context);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (target instanceof CowEntity) {
            playerIn.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            ItemStack returnStack = this.fillKettle(stack.func_77946_l(), playerIn, new ItemStack((IItemProvider)ModItems.MILK_KETTLE.get()));
            playerIn.func_184611_a(hand, returnStack);
            return ActionResultType.func_233537_a_((boolean)playerIn.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ActionResult<ItemStack> result = this.tryCollectWater(worldIn, playerIn, handIn);
        if (result.func_188397_a().func_226246_a_()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            ItemStack filledStack = (ItemStack)result.func_188398_b();
            return new ActionResult(result.func_188397_a(), (Object)this.fillKettle(stack.func_77946_l(), playerIn, filledStack));
        }
        return result;
    }

    protected ActionResult<ItemStack> tryCollectWater(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult rayTrace = EmptyKettleItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_216350_a();
            if (!worldIn.func_175660_a(playerIn, pos)) {
                return ActionResult.func_226250_c_((Object)stack);
            }
            if (worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                ItemStack filledStack = new ItemStack((IItemProvider)ModItems.WATER_KETTLE.get());
                worldIn.func_184148_a(playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                return ActionResult.func_233538_a_((Object)filledStack, (boolean)worldIn.field_72995_K);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    protected ItemStack fillKettle(ItemStack emptyStack, PlayerEntity player, ItemStack stack) {
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return DrinkHelper.func_242398_a((ItemStack)emptyStack, (PlayerEntity)player, (ItemStack)stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack(stack, 1000){

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return stack.getFluid() == Fluids.field_204546_a;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                if (resource.getAmount() >= 1000) {
                    super.fill(resource, doFill);
                    this.container = new ItemStack((IItemProvider)ModItems.WATER_KETTLE.get());
                    return 1000;
                }
                return 0;
            }
        };
    }
}

