/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.items;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.NonNullList;
import soulspark.tea_kettle.common.blocks.FilledKettleBlock;
import soulspark.tea_kettle.common.blocks.KettleBlock;
import soulspark.tea_kettle.common.items.KettleItem;

public class FilledKettleItem
extends KettleItem {
    protected final boolean isHot;

    public FilledKettleItem(KettleBlock block, boolean isHot, Item.Properties builder) {
        super(block, builder);
        this.isHot = isHot;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + (this.isHot ? "_hot" : "");
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isHot) {
            super.func_150895_a(group, items);
        }
    }

    public ItemStack getContainerItem(ItemStack stack) {
        CompoundNBT kettleTag = stack.func_196082_o();
        CompoundNBT blockStateTag = kettleTag.func_74775_l("BlockStateTag");
        int fullness = blockStateTag.func_74762_e("fullness");
        if (fullness == 0) {
            fullness = 4;
        }
        if (--fullness <= 0) {
            return super.getContainerItem(stack);
        }
        blockStateTag.func_74768_a("fullness", fullness);
        kettleTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
        stack.func_77982_d(kettleTag);
        return stack;
    }

    @Nullable
    protected BlockState func_195945_b(BlockItemUseContext context) {
        BlockState state = super.func_195945_b(context);
        if (state != null && state.func_177230_c() == this.func_179223_d()) {
            return (BlockState)state.func_206870_a((Property)FilledKettleBlock.HOT, (Comparable)Boolean.valueOf(this.isHot));
        }
        return state;
    }
}

