/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.util.TeaKettleUtils;

public class TeaItem
extends BlockItem {
    public TeaItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public SoundEvent func_225519_S__() {
        return SoundEvents.field_187664_bz;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return DrinkHelper.func_234707_a_((World)worldIn, (PlayerEntity)playerIn, (Hand)handIn);
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        if (context.func_195999_j() != null && !context.func_195999_j().func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        return super.func_195942_a(context);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        PlayerEntity player;
        if (!worldIn.field_72995_K) {
            entityLiving.getPersistentData().func_74780_a("TeaKettleSweetnessFactor", 1.0 + Math.max(0.0, (double)(TeaKettleUtils.getSweetness(stack) * 2.0f) - 0.5));
        }
        super.func_77654_b(stack, worldIn, entityLiving);
        entityLiving.getPersistentData().func_82580_o("TeaKettleSweetnessFactor");
        PlayerEntity playerEntity = player = entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null;
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, stack);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        if (player != null) {
            ItemStack cupStack = new ItemStack((IItemProvider)ModItems.CUP.get());
            if (stack.func_190926_b()) {
                return cupStack;
            }
            if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(cupStack)) {
                player.func_71019_a(cupStack, false);
            }
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        switch ((int)(TeaKettleUtils.getSweetness(stack) * 2.0f)) {
            case 1: {
                tooltip.add((ITextComponent)new TranslationTextComponent("tea_kettle.tea_sweetened_weak").func_240700_a_(style -> style.func_240723_c_(TextFormatting.GRAY)));
                break;
            }
            case 2: {
                tooltip.add((ITextComponent)new TranslationTextComponent("tea_kettle.tea_sweetened_strong").func_240700_a_(style -> style.func_240723_c_(TextFormatting.GRAY)));
            }
        }
    }
}

