/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import soulspark.tea_kettle.core.init.ModRecipeTypes;

public class TeaMixingRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack result;

    public TeaMixingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)this.ingredient, (Object[])new Ingredient[]{this.ingredient});
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.TEA_MIXING_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.TEA_MIXING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TeaMixingRecipe> {
        public TeaMixingRecipe read(ResourceLocation recipeId, JsonObject json) {
            ItemStack itemStack;
            JsonArray ingredientJson = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientJson);
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (json.get("result").isJsonObject()) {
                itemStack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemStack = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            return new TeaMixingRecipe(recipeId, ingredient, itemStack);
        }

        public TeaMixingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return new TeaMixingRecipe(recipeId, ingredient, itemstack);
        }

        public void write(PacketBuffer buffer, TeaMixingRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

