/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.init.ModRecipeTypes;

public class TeaSteepingRecipe
implements IRecipe<IInventory> {
    protected final ResourceLocation id;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;

    public TeaSteepingRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            recipeitemhelper.func_221264_a(itemstack, 1);
        }
        return i == this.ingredients.size() && recipeitemhelper.func_194116_a((IRecipe)this, null);
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.TEA_STEEPING_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.TEA_STEEPING;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModItems.BOILING_KETTLE.get());
    }

    public static interface IFactory<T extends TeaSteepingRecipe> {
        public T create(ResourceLocation var1, NonNullList<Ingredient> var2, ItemStack var3);
    }

    public static class Serializer<T extends TeaSteepingRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for tea recipe");
            }
            if (ingredients.size() > 2) {
                throw new JsonParseException("Too many ingredients for shapeless recipe, max is 2");
            }
            String resultName = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ItemStack result = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(new ResourceLocation(resultName)).orElseThrow(() -> new IllegalStateException("Item: " + resultName + " does not exist")));
            return this.factory.create(recipeId, ingredients, result);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemStack = buffer.func_150791_c();
            return this.factory.create(recipeId, (NonNullList<Ingredient>)ingredients, itemStack);
        }

        public void write(PacketBuffer buffer, TeaSteepingRecipe recipe) {
            buffer.func_150787_b(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.result);
        }
    }
}

