/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.core;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import soulspark.tea_kettle.common.blocks.IGrabbable;
import soulspark.tea_kettle.core.compat.CompatHandler;
import soulspark.tea_kettle.core.init.ModBlocks;
import soulspark.tea_kettle.core.init.ModEffects;
import soulspark.tea_kettle.core.init.ModFeatures;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.util.TeaKettleTags;
import soulspark.tea_kettle.core.util.TeaKettleUtils;

public class CommonEvents {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null && event.getCategory() == Biome.Category.FOREST || BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName()), (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.TEA_BUSH);
        }
    }

    @SubscribeEvent
    public static void onPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        double sweetnessFactor;
        if (ModList.get().isLoaded("simplytea")) {
            CommonEvents.excludeCaffeineEffects(event);
        }
        if ((sweetnessFactor = event.getEntityLiving().getPersistentData().func_74769_h("TeaKettleSweetnessFactor")) != 0.0) {
            EffectInstance oldEffect = event.getPotionEffect();
            EffectInstance newEffect = new EffectInstance(oldEffect.func_188419_a(), (int)((double)oldEffect.func_76459_b() * sweetnessFactor), oldEffect.func_76458_c(), oldEffect.func_82720_e(), oldEffect.func_188418_e());
            event.getEntityLiving().getPersistentData().func_82580_o("TeaKettleSweetnessFactor");
            event.getEntityLiving().func_195064_c(newEffect);
            event.setResult(Event.Result.DENY);
        }
    }

    private static void excludeCaffeineEffects(PotionEvent.PotionApplicableEvent event) {
        Effect caffeinated = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation("simplytea:caffeinated"));
        if (caffeinated != null) {
            if (event.getPotionEffect().func_188419_a() == caffeinated) {
                event.getEntityLiving().func_195063_d((Effect)ModEffects.CAFFEINE.get());
            } else if (event.getPotionEffect().func_188419_a() == ModEffects.CAFFEINE.get()) {
                event.getEntityLiving().func_195063_d(caffeinated);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockItem blockItem;
        World world = event.getWorld();
        ItemStack handStack = event.getItemStack();
        Item item = handStack.func_77973_b();
        PlayerEntity player = event.getPlayer();
        BlockState state = world.func_180495_p(event.getPos());
        if (CompatHandler.onRightClickBlock(event) != ActionResultType.PASS) {
            return;
        }
        if (event.getHand() == Hand.MAIN_HAND && player.func_225608_bj_() && state.func_177230_c() instanceof IGrabbable) {
            IGrabbable grabbable = (IGrabbable)state.func_177230_c();
            ItemStack grabStack = grabbable.getGrabStack(state, event.getWorld(), event.getPos()).func_77946_l();
            if (handStack.func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, grabStack);
            } else if (handStack.func_77969_a(grabStack) && handStack.func_190916_E() < handStack.func_77976_d()) {
                handStack.func_190917_f(1);
            } else if (!player.field_71071_by.func_70441_a(grabStack)) {
                return;
            }
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
            } else {
                player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
            }
            grabbable.grab(event.getWorld(), event.getPos());
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
        } else if (handStack.func_77973_b() == ModItems.EMPTY_KETTLE.get() && state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) == 3) {
            player.func_184611_a(event.getHand(), DrinkHelper.func_242398_a((ItemStack)handStack.func_77946_l(), (PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_KETTLE.get())));
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, event.getPos(), state, 0);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
        } else if (player.func_225608_bj_() && event.getFace() != null && (blockItem = ModBlocks.TEA_ITEM_TO_BLOCK.get(item.getRegistryName())) != null) {
            ActionResultType result;
            ItemStack blockItemStack = new ItemStack((IItemProvider)blockItem);
            if (handStack.func_77942_o()) {
                blockItemStack.func_77982_d(handStack.func_77978_p().func_74737_b());
            }
            if ((result = blockItem.func_195942_a(new BlockItemUseContext(player, event.getHand(), blockItemStack, new BlockRayTraceResult(player.func_70040_Z(), event.getFace(), event.getPos(), false)))).func_226246_a_()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    handStack.func_190918_g(1);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUsed(LivingEntityUseItemEvent.Tick event) {
        ItemStack handStack = event.getItem();
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getDuration() == 1 && ModBlocks.TEA_ITEM_TO_BLOCK.containsKey(handStack.func_77973_b().getRegistryName())) {
            double sweetnessFactor;
            Food food = handStack.func_77973_b().func_219967_s();
            if (food != null && food.func_221464_f().size() > 0) {
                sweetnessFactor = 0.75 + 0.25 * Math.pow(TeaKettleUtils.getSweetness(handStack) * 2.0f, 1.6);
            } else if (handStack.func_77973_b().func_206844_a(TeaKettleTags.LAVENDER_TEA)) {
                sweetnessFactor = 1.0 + Math.max(0.0, (double)(TeaKettleUtils.getSweetness(handStack) * 2.0f) - 0.5);
            } else {
                return;
            }
            event.getEntityLiving().getPersistentData().func_74780_a("TeaKettleSweetnessFactor", sweetnessFactor);
        }
    }

    @SubscribeEvent
    public static void onSleepLocationCheck(SleepingLocationCheckEvent event) {
        PlayerEntity player;
        LivingEntity entity = event.getEntityLiving();
        PlayerEntity playerEntity = player = entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        if (!entity.func_70644_a((Effect)ModEffects.ZEN.get()) && entity.func_70644_a((Effect)ModEffects.CAFFEINE.get()) && (player == null || player.func_71060_bI() > 50)) {
            event.setResult(Event.Result.DENY);
            if (player != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.caffeine"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        boolean zen = event.getEntityLiving().func_70644_a((Effect)ModEffects.ZEN.get());
        boolean caffeine = event.getEntityLiving().func_70644_a((Effect)ModEffects.CAFFEINE.get());
        if (zen && !caffeine) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onWakeUpEvent(SleepFinishedTimeEvent event) {
        for (PlayerEntity player : event.getWorld().func_217369_A()) {
            player.func_195063_d((Effect)ModEffects.ZEN.get());
        }
    }
}

