/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.core.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import soulspark.tea_kettle.common.blocks.CupBlock;
import soulspark.tea_kettle.common.blocks.EmptyKettleBlock;
import soulspark.tea_kettle.common.blocks.FilledKettleBlock;
import soulspark.tea_kettle.common.blocks.KettleBlock;
import soulspark.tea_kettle.common.blocks.LegacyKettleBlock;
import soulspark.tea_kettle.common.blocks.SimplyTeaBlock;
import soulspark.tea_kettle.common.blocks.TeaBlock;
import soulspark.tea_kettle.common.blocks.TeaBushBlock;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.util.TeaKettleUtils;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tea_kettle");
    public static final ArrayList<CupBlock> CUPS = new ArrayList();
    public static final Map<ResourceLocation, BlockItem> TEA_ITEM_TO_BLOCK = new HashMap<ResourceLocation, BlockItem>();
    public static final AbstractBlock.Properties KETTLE_PROPERTIES = AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151649_A).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e).func_226896_b_();
    public static final AbstractBlock.Properties CUP_PROPERTIES = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193561_M).func_200943_b(0.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_();
    public static final RegistryObject<TeaBushBlock> TEA_BUSH = BLOCKS.register("tea_bush", () -> new TeaBushBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c().func_200942_a().func_200947_a(SoundType.field_222471_r).func_226896_b_()));
    public static final RegistryObject<LegacyKettleBlock> LEGACY_KETTLE = BLOCKS.register("kettle", () -> new LegacyKettleBlock(KETTLE_PROPERTIES));
    public static final RegistryObject<KettleBlock> EMPTY_KETTLE = BLOCKS.register("empty_kettle", () -> new EmptyKettleBlock(KETTLE_PROPERTIES));
    public static final RegistryObject<FilledKettleBlock> WATER_KETTLE = BLOCKS.register("water_kettle", () -> new FilledKettleBlock(isHot -> isHot != false ? (Item)ModItems.BOILING_KETTLE.get() : (Item)ModItems.WATER_KETTLE.get(), KETTLE_PROPERTIES));
    public static final RegistryObject<FilledKettleBlock> MILK_KETTLE = BLOCKS.register("milk_kettle", () -> new FilledKettleBlock(isHot -> isHot != false ? (Item)ModItems.FROTHING_KETTLE.get() : (Item)ModItems.MILK_KETTLE.get(), KETTLE_PROPERTIES));
    public static final RegistryObject<CupBlock> CUP = BLOCKS.register("cup", () -> new CupBlock(CUP_PROPERTIES));
    public static final RegistryObject<TeaBlock> GREEN_TEA = ModBlocks.registerTea("green_tea");
    public static final RegistryObject<TeaBlock> WHITE_TEA = ModBlocks.registerTea("white_tea");
    public static final RegistryObject<TeaBlock> OOLONG_TEA = ModBlocks.registerTea("oolong_tea");
    public static final RegistryObject<TeaBlock> BLACK_TEA = ModBlocks.registerTea("black_tea");
    public static final RegistryObject<TeaBlock> ROSE_TEA = ModBlocks.registerTea("rose_tea");
    public static final RegistryObject<TeaBlock> BAMBOO_TEA = ModBlocks.registerTea("bamboo_tea");
    public static final RegistryObject<TeaBlock> GREEN_LATTE = ModBlocks.registerTea("green_latte");
    public static final RegistryObject<TeaBlock> WHITE_LATTE = ModBlocks.registerTea("white_latte");
    public static final RegistryObject<TeaBlock> OOLONG_LATTE = ModBlocks.registerTea("oolong_latte");
    public static final RegistryObject<TeaBlock> BLACK_LATTE = ModBlocks.registerTea("black_latte");

    private static RegistryObject<TeaBlock> registerTea(String name) {
        return BLOCKS.register(name, () -> new TeaBlock(CUP_PROPERTIES));
    }

    public static void registerSimplyTea(ResourceLocation name, IForgeRegistry<Block> registry) {
        ModBlocks.registerExternalBlock(nameIn -> new SimplyTeaBlock(name, CUP_PROPERTIES), name, registry);
    }

    public static void registerExternalBlock(Function<ResourceLocation, Block> constructor, ResourceLocation itemName, IForgeRegistry<Block> registry) {
        ResourceLocation blockName = TeaKettleUtils.getExternalBlockName(itemName);
        Block block = (Block)constructor.apply(itemName).setRegistryName(blockName);
        registry.register((IForgeRegistryEntry)block);
        TEA_ITEM_TO_BLOCK.put(itemName, new BlockItem(block, new Item.Properties()));
    }
}

