/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.core.init;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Food;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import soulspark.tea_kettle.common.blocks.CupBlock;
import soulspark.tea_kettle.common.blocks.KettleBlock;
import soulspark.tea_kettle.common.blocks.TeaBlock;
import soulspark.tea_kettle.common.items.CupItem;
import soulspark.tea_kettle.common.items.EmptyKettleItem;
import soulspark.tea_kettle.common.items.FilledKettleItem;
import soulspark.tea_kettle.common.items.LatteItem;
import soulspark.tea_kettle.common.items.LegacyKettleItem;
import soulspark.tea_kettle.common.items.TeaItem;
import soulspark.tea_kettle.core.init.ModBlocks;
import soulspark.tea_kettle.core.init.ModEffects;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tea_kettle");
    private static final Item.Properties KETTLE_PROPERTIES = new Item.Properties().func_200917_a(1);
    public static final ArrayList<RegistryObject<TeaItem>> TEAS = new ArrayList();
    public static final RegistryObject<LegacyKettleItem> LEGACY_KETTLE = ITEMS.register("kettle", () -> new LegacyKettleItem(KETTLE_PROPERTIES));
    public static final RegistryObject<EmptyKettleItem> EMPTY_KETTLE = ITEMS.register("empty_kettle", () -> new EmptyKettleItem((KettleBlock)ModBlocks.EMPTY_KETTLE.get(), KETTLE_PROPERTIES.func_200916_a(ItemGroup.field_78031_c).func_200917_a(16)));
    public static final RegistryObject<FilledKettleItem> WATER_KETTLE = ITEMS.register("water_kettle", () -> new FilledKettleItem((KettleBlock)ModBlocks.WATER_KETTLE.get(), false, KETTLE_PROPERTIES.func_200916_a(ItemGroup.field_78027_g).func_200917_a(1)));
    public static final RegistryObject<FilledKettleItem> BOILING_KETTLE = ITEMS.register("boiling_kettle", () -> new FilledKettleItem((KettleBlock)ModBlocks.WATER_KETTLE.get(), true, KETTLE_PROPERTIES.func_200916_a(ItemGroup.field_78031_c).func_200919_a((Item)EMPTY_KETTLE.get())));
    public static final RegistryObject<FilledKettleItem> MILK_KETTLE = ITEMS.register("milk_kettle", () -> new FilledKettleItem((KettleBlock)ModBlocks.MILK_KETTLE.get(), false, KETTLE_PROPERTIES.func_200916_a(ItemGroup.field_78027_g)));
    public static final RegistryObject<FilledKettleItem> FROTHING_KETTLE = ITEMS.register("frothing_kettle", () -> new FilledKettleItem((KettleBlock)ModBlocks.MILK_KETTLE.get(), true, KETTLE_PROPERTIES.func_200916_a(ItemGroup.field_78031_c).func_200919_a((Item)EMPTY_KETTLE.get())));
    public static final RegistryObject<CupItem> CUP = ITEMS.register("cup", () -> new CupItem((CupBlock)ModBlocks.CUP.get(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(16)));
    public static final RegistryObject<TeaItem> GREEN_TEA = ModItems.registerTea("green_tea", ModBlocks.GREEN_TEA, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76428_l, 120, 0), 1.0f).func_221454_a(0.1f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 900, 0), 1.0f));
    public static final RegistryObject<TeaItem> WHITE_TEA = ModItems.registerTea("white_tea", ModBlocks.WHITE_TEA, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76428_l, 140, 0), 1.0f).func_221454_a(0.3f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 120, 0), 1.0f));
    public static final RegistryObject<TeaItem> OOLONG_TEA = ModItems.registerTea("oolong_tea", ModBlocks.OOLONG_TEA, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76444_x, 240, 0), 1.0f).func_221454_a(0.1f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 1200, 0), 1.0f));
    public static final RegistryObject<TeaItem> BLACK_TEA = ModItems.registerTea("black_tea", ModBlocks.BLACK_TEA, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76424_c, 160, 0), 1.0f).func_221454_a(0.2f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 1800, 0), 1.0f));
    public static final RegistryObject<TeaItem> BAMBOO_TEA = ModItems.registerTea("bamboo_tea", ModBlocks.BAMBOO_TEA, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76429_m, 240, 0), 1.0f).func_221454_a(0.3f));
    public static final RegistryObject<TeaItem> ROSE_TEA = ModItems.registerTea("rose_tea", ModBlocks.ROSE_TEA, new Food.Builder().effect(() -> new EffectInstance((Effect)ModEffects.ZEN.get(), 300, 0), 1.0f).func_221454_a(0.2f));
    public static final RegistryObject<TeaItem> GREEN_LATTE = ModItems.registerLatte("green_latte", ModBlocks.GREEN_LATTE, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76428_l, 100, 1), 1.0f).func_221454_a(0.3f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 600, 0), 1.0f));
    public static final RegistryObject<TeaItem> WHITE_LATTE = ModItems.registerLatte("white_latte", ModBlocks.WHITE_LATTE, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76428_l, 120, 1), 1.0f).func_221454_a(0.5f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 80, 0), 1.0f));
    public static final RegistryObject<TeaItem> OOLONG_LATTE = ModItems.registerLatte("oolong_latte", ModBlocks.OOLONG_LATTE, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76444_x, 220, 1), 1.0f).func_221454_a(0.1f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 800, 0), 1.0f));
    public static final RegistryObject<TeaItem> BLACK_LATTE = ModItems.registerLatte("black_latte", ModBlocks.BLACK_LATTE, new Food.Builder().func_221452_a(new EffectInstance(Effects.field_76424_c, 160, 0), 1.0f).func_221454_a(0.4f).effect(() -> new EffectInstance((Effect)ModEffects.CAFFEINE.get(), 1200, 1), 1.0f));
    public static final RegistryObject<Item> ROSE_PETAL = ITEMS.register("rose_petal", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<Item> BAMBOO_LEAF = ITEMS.register("bamboo_leaf", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<BlockNamedItem> TEA_LEAF = ITEMS.register("tea_leaf", () -> new BlockNamedItem((Block)ModBlocks.TEA_BUSH.get(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<Item> WHITE_TEA_LEAF = ITEMS.register("white_tea_leaf", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<Item> OOLONG_TEA_LEAF = ITEMS.register("oolong_tea_leaf", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<Item> BLACK_TEA_LEAF = ITEMS.register("black_tea_leaf", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    public static final RegistryObject<HoneyBottleItem> HALF_HONEY_BOTTLE = ITEMS.register("half_honey_bottle", () -> new HoneyBottleItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(16).func_221540_a(new Food.Builder().func_221456_a(3).func_221454_a(0.1f).func_221453_d()).func_200919_a(Items.field_151069_bo)));

    public static RegistryObject<TeaItem> registerTea(String name, RegistryObject<TeaBlock> block, Food.Builder foodBuilder) {
        RegistryObject entry = ITEMS.register(name, () -> new TeaItem((Block)block.get(), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1).func_221540_a(foodBuilder.func_221456_a(3).func_221453_d())));
        TEAS.add((RegistryObject<TeaItem>)entry);
        return entry;
    }

    public static RegistryObject<TeaItem> registerLatte(String name, RegistryObject<TeaBlock> block, Food.Builder foodBuilder) {
        RegistryObject entry = ITEMS.register(name, () -> new LatteItem((Block)block.get(), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1).func_221540_a(foodBuilder.func_221456_a(4).func_221453_d())));
        TEAS.add((RegistryObject<TeaItem>)entry);
        return entry;
    }
}

