/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.core.jei;

import java.util.Collection;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import soulspark.tea_kettle.common.recipes.MilkyDrinkRecipe;
import soulspark.tea_kettle.common.recipes.TeaSteepingRecipe;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.init.ModRecipeTypes;
import soulspark.tea_kettle.core.jei.TeaMixingRecipeCategory;
import soulspark.tea_kettle.core.jei.TeaSteepingRecipeCategory;

@JeiPlugin
public class KettleJEIPlugin
implements IModPlugin {
    public TeaSteepingRecipeCategory<TeaSteepingRecipe> teaSteepingCategory;
    public TeaSteepingRecipeCategory<MilkyDrinkRecipe> teaMilkingCategory;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("tea_kettle", "main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.teaSteepingCategory = new TeaSteepingRecipeCategory<TeaSteepingRecipe>(TeaSteepingRecipe.class, "tea_steeping", new ItemStack((IItemProvider)ModItems.GREEN_TEA.get()), registry.getJeiHelpers().getGuiHelper());
        this.teaMilkingCategory = new TeaSteepingRecipeCategory<MilkyDrinkRecipe>(MilkyDrinkRecipe.class, "milky_drink", new ItemStack((IItemProvider)ModItems.FROTHING_KETTLE.get()), registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.teaSteepingCategory});
        registry.addRecipeCategories(new IRecipeCategory[]{this.teaMilkingCategory});
        registry.addRecipeCategories(new IRecipeCategory[]{new TeaMixingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(ModRecipeTypes.TEA_STEEPING), this.teaSteepingCategory.UID);
            registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(ModRecipeTypes.MILKY_DRINK), this.teaMilkingCategory.UID);
            registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(ModRecipeTypes.TEA_MIXING), TeaMixingRecipeCategory.UID);
            registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(ModRecipeTypes.SHEARING), VanillaRecipeCategoryUid.CRAFTING);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.CUP.get());
        registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{this.teaSteepingCategory.UID});
        registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{this.teaMilkingCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.BOILING_KETTLE.get()), new ResourceLocation[]{this.teaSteepingCategory.UID});
        stack = new ItemStack((IItemProvider)ModItems.FROTHING_KETTLE.get());
        registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{this.teaMilkingCategory.UID});
        registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{TeaMixingRecipeCategory.UID});
        if (ModList.get().isLoaded("simplytea")) {
            registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simplytea:teapot_hot"))), new ResourceLocation[]{this.teaSteepingCategory.UID});
            stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simplytea:teapot_frothed")));
            registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{this.teaMilkingCategory.UID});
            registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{TeaMixingRecipeCategory.UID});
        }
    }
}

