/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.core.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import soulspark.tea_kettle.common.recipes.TeaMixingRecipe;
import soulspark.tea_kettle.core.init.ModItems;

public class TeaMixingRecipeCategory
implements IRecipeCategory<TeaMixingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("tea_kettle", "tea_mixing");
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;

    public TeaMixingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("tea_kettle:textures/gui/jei_tea_mixing.png"), 0, 0, 96, 44);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.BLACK_LATTE.get()));
        this.title = I18n.func_135052_a((String)"tea_kettle.jei.tea_mixing", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends TeaMixingRecipe> getRecipeClass() {
        return TeaMixingRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(TeaMixingRecipe teaMixingRecipe, IIngredients iIngredients) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (Ingredient ingredient : teaMixingRecipe.func_192400_c()) {
            inputs.add((Object[])ingredient.func_193365_a());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, (List)inputs.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)teaMixingRecipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, TeaMixingRecipe teaMixingRecipe, IIngredients iIngredients) {
        iRecipeLayout.getItemStacks().init(0, true, 6, 20);
        iRecipeLayout.getItemStacks().set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        iRecipeLayout.getItemStacks().init(3, true, 73, 20);
        iRecipeLayout.getItemStacks().set(3, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

