/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.core.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import soulspark.tea_kettle.common.recipes.TeaSteepingRecipe;

public class TeaSteepingRecipeCategory<T extends TeaSteepingRecipe>
implements IRecipeCategory<T> {
    public final ResourceLocation UID;
    protected final Class<? extends T> recipeClass;
    protected final IDrawable[] backgrounds;
    protected final IDrawable icon;
    protected final String title;

    public TeaSteepingRecipeCategory(Class<? extends T> recipeClass, String name, ItemStack iconStack, IGuiHelper helper) {
        this.recipeClass = recipeClass;
        this.UID = new ResourceLocation("tea_kettle", name);
        this.backgrounds = new IDrawable[]{helper.createDrawable(new ResourceLocation(String.format("tea_kettle:textures/gui/jei_%s.png", this.UID.func_110623_a())), 0, 0, 96, 44), helper.createDrawable(new ResourceLocation(String.format("tea_kettle:textures/gui/jei_%s_pair.png", this.UID.func_110623_a())), 0, 0, 96, 44)};
        this.icon = helper.createDrawableIngredient((Object)iconStack);
        this.title = I18n.func_135052_a((String)("tea_kettle.jei." + this.UID.func_110623_a()), (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return this.UID;
    }

    public Class<? extends T> getRecipeClass() {
        return this.recipeClass;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.backgrounds[0];
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int ingredientCount = ((TeaSteepingRecipe)recipe).func_192400_c().size();
        if (ingredientCount == 2) {
            this.backgrounds[1].draw(matrixStack);
        }
    }

    public void setIngredients(T recipe, IIngredients iIngredients) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (Ingredient ingredient : ((TeaSteepingRecipe)recipe).func_192400_c()) {
            inputs.add((Object[])ingredient.func_193365_a());
        }
        iIngredients.setInputIngredients(((TeaSteepingRecipe)recipe).func_192400_c());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)((TeaSteepingRecipe)recipe).func_77571_b());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, T recipe, IIngredients iIngredients) {
        int i = 0;
        iRecipeLayout.getItemStacks().init(i, true, 6, 20);
        iRecipeLayout.getItemStacks().set(i++, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        if (((TeaSteepingRecipe)recipe).func_192400_c().size() > 1) {
            iRecipeLayout.getItemStacks().init(i, true, 24, 20);
            iRecipeLayout.getItemStacks().set(i++, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(1));
        }
        iRecipeLayout.getItemStacks().init(i, true, 73, 20);
        iRecipeLayout.getItemStacks().set(i, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

