/*
 * Decompiled with CFR 0.152.
 */
package soulspark.tea_kettle.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import soulspark.tea_kettle.core.init.ModBlocks;
import soulspark.tea_kettle.core.init.ModItems;
import soulspark.tea_kettle.core.util.TeaKettleUtils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="tea_kettle")
public class DataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            BlockTagsProvider blockTagsProvider = new BlockTagsProvider(gen){

                protected void func_200432_c() {
                }
            };
            gen.func_200390_a((IDataProvider)new Recipes(gen));
            gen.func_200390_a((IDataProvider)blockTagsProvider);
            gen.func_200390_a((IDataProvider)new TagsProvider(gen, blockTagsProvider, event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new LootProvider(gen));
        }
    }

    public static class LootProvider
    extends LootTableProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.field_216267_h));

        public LootProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return this.lootTables;
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        }
    }

    public static class BlockTables
    extends BlockLootTables {
        protected void addTables() {
            ModBlocks.TEA_ITEM_TO_BLOCK.forEach((key, value) -> {
                ITag tag = (ITag)TagsProvider.EXTERNAL_BLOCKS_TAGS.get(key);
                this.func_218522_a(value.func_179223_d(), block -> LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockTables.func_218560_a((IItemProvider)value, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b((ITag)tag)))));
            });
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.TEA_ITEM_TO_BLOCK.values().stream().map(BlockItem::func_179223_d)::iterator;
        }
    }

    public static class TagsProvider
    extends ItemTagsProvider {
        public static final Map<ResourceLocation, ITag.INamedTag<Item>> EXTERNAL_BLOCKS_TAGS = new HashMap<ResourceLocation, ITag.INamedTag<Item>>();

        public TagsProvider(DataGenerator generatorIn, BlockTagsProvider blockTagsProvider, ExistingFileHelper helper) {
            super(generatorIn, blockTagsProvider, "tea_kettle", helper);
        }

        protected void func_200432_c() {
            ModBlocks.TEA_ITEM_TO_BLOCK.forEach((key, value) -> this.func_240522_a_(TagsProvider.tag(key)).addOptional(key));
        }

        private static ITag.INamedTag<Item> tag(ResourceLocation itemName) {
            ITag.INamedTag wrapperTag = ItemTags.func_199901_a((String)TeaKettleUtils.getExternalBlockName(itemName).toString());
            EXTERNAL_BLOCKS_TAGS.put(itemName, (ITag.INamedTag<Item>)wrapperTag);
            return wrapperTag;
        }
    }

    public static class Recipes
    extends RecipeProvider
    implements IConditionBuilder {
        public Recipes(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            ConditionalRecipe.builder().addCondition(this.modLoaded("abundance")).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ModItems.BAMBOO_TEA.get())).func_200487_b((IItemProvider)ModItems.BAMBOO_LEAF.get()).func_200483_a("has_material", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)ModItems.BAMBOO_LEAF.get())))).func_200482_a(arg_0)).build(consumer, new ResourceLocation("tea_kettle", "abundance_lavender_tea"));
        }
    }
}

