/*
 * Decompiled with CFR 0.152.
 */
package timeisup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import timeisup.capabilities.Timer;

@Mod.EventBusSubscriber(modid="timeisup")
public class Configs {
    public static List<Integer> warnings;
    public static List<Integer> blacklist;
    public static int dangerous;
    public static int emergency;
    public static Timer defaultTimer;
    public static HashMap<Integer, Timer> basetimers;
    public static boolean potionEffect;
    public static List<PotionEffect> emergencyEffects;
    public static List<PotionEffect> dangerousEffects;
    public static List<PotionEffect> TimeIsUpEffects;
    public static int cooldownEffects;
    public static HashMap<ResourceLocation, List<Biome.SpawnListEntry>> DoomSpawners;
    public static float mobSpawningChance;
    public static float exileChance;
    public static int exileStrength;
    public static NBTTagCompound boss;
    public static String bossMessage;
    public static boolean globalTimer;
    private static final String BASECATEGORY = "Configs";
    private static final String EFFECTSCATEGORY = "Effects";
    private static final String BOSSCATEGORY = "Boss";
    private static Configuration configs;

    @SubscribeEvent
    public static void onCfgChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("timeisup".equals(event.getModID())) {
            configs.save();
            Configs.bakeConfig();
        }
    }

    public static void loadConfigs() {
        configs.load();
        Configs.bakeConfig();
        configs.save();
    }

    private static void bakeConfig() {
        warnings = Arrays.asList(ArrayUtils.toObject((int[])configs.get(BASECATEGORY, "Warnings", Configs.defaultWarnings(), "Play a warning sound at these ticks. [default: [1220, 620] ]").getIntList()));
        dangerous = configs.getInt("Dangerous", BASECATEGORY, 620, 0, Integer.MAX_VALUE, "Tick when the timer becomes red. [default:620]");
        emergency = configs.getInt("Emergency", BASECATEGORY, 220, 0, Integer.MAX_VALUE, "Tick when the timer comes in the front of the screen [default:220]");
        int defaultDuration = configs.getInt("Default duration", BASECATEGORY, 12000, 0, Integer.MAX_VALUE, "Default duration when the player comes for the first time in this dimension. [default:12000 = 10 minutes]");
        int defaultTickPerDuration = configs.getInt("Default ticks per duration", BASECATEGORY, 4, 1, Integer.MAX_VALUE, "Default tick amount to spend in an other dimension to recover ticks in this dimension. [default:4]");
        int defaultMaxDuration = configs.getInt("Default max duration", BASECATEGORY, 72000, 0, Integer.MAX_VALUE, "Default max duration that can be accumulated for a dimension. [default:72000 = 1 hour]");
        int defaultAmountPerRecover = configs.getInt("Default amount recovered", BASECATEGORY, 1, 1, Integer.MAX_VALUE, "Default amount of ticks recovered per tick recover. [default:1]");
        defaultTimer = new Timer(defaultDuration, defaultTickPerDuration, defaultMaxDuration, defaultAmountPerRecover);
        globalTimer = configs.getBoolean("Global timer", BASECATEGORY, false, "Set to true to use the same shared timer for all dimensions");
        blacklist = Arrays.asList(ArrayUtils.toObject((int[])configs.get(BASECATEGORY, "BlackList", Configs.defaultBlackList(), "Dimensions where there is NO timer").getIntList()));
        Configs.deserializeTimers(Arrays.asList(configs.getStringList("Default timers", BASECATEGORY, new String[0], "Default timer for each dimension.\nFormat for one dimension : \"dimension_id;default_duration;ticks_per_duration;max_duration;amount_recovered\".\nExample : \"-1;12000;4;72000;3\" (-1 = nether)")), defaultAmountPerRecover);
        exileChance = configs.getFloat("Exile chances", EFFECTSCATEGORY, 0.05f, 0.0f, 1.0f, "Chances to get Exile Effect by killing a mob.");
        exileStrength = configs.getInt("Exile amplifier", EFFECTSCATEGORY, 0, 0, 255, "Exile Effect amplifier");
        Configs.deserializeDoomSpawners(Arrays.asList(configs.getStringList("Doom spawners", EFFECTSCATEGORY, new String[0], String.join((CharSequence)"\n", "Sets mobs that can be spawned by doom effect.", "If a dimension or biome is not set, default spawnset for biome will be used.", "format :  dimension_or_biome_name;entry1;entry2; ...", "entry format : entity_name,weight,minCount,maxCount", "weight - higher weight mean higher chance to spawn", "minCount - minimum group size", "maxCount - maximum group size"))));
        mobSpawningChance = configs.getFloat("Doom spawn chance", EFFECTSCATEGORY, 0.6f, 0.0f, 1.0f, "Sets the spawn chance when doom performs its effect.\nAssuming nothing else is preventing spawning.");
        bossMessage = configs.getString("Boss message", BOSSCATEGORY, "\u00a76You are now free to travel across dimensions without any limit.", "Message sent when the player killed the boss.");
        String strboss = configs.getString(BOSSCATEGORY, BOSSCATEGORY, "{id:\"minecraft:ender_dragon\"}", "NBT of the boss.\nEvery entity matching this NBT is considered as boss.\nOnce the player has killed the boss, his timers are disabled.\nLeaving this blank will disable boss functionality.");
        if (!strboss.isEmpty()) {
            try {
                boss = JsonToNBT.func_180713_a((String)strboss);
            }
            catch (NBTException e1) {
                e1.printStackTrace();
            }
        }
        cooldownEffects = configs.getInt("effects cooldown", EFFECTSCATEGORY, 80, 1, Integer.MAX_VALUE, "Cooldown before applying effects. [80 ticks by default]");
        potionEffect = configs.getBoolean("Potion Effects", BASECATEGORY, false, "When time is up, the player die if set to false or receive bad potion effects if set to true");
        try {
            Configs.setEffects();
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
    }

    private static void setEffects() throws NBTException {
        if (potionEffect) {
            String[] TimeIsUpEffectsStrings;
            String[] dangerousEffectsStrings;
            String[] emergencyEffectsStrings;
            emergencyEffects = new ArrayList<PotionEffect>();
            for (String effect : emergencyEffectsStrings = configs.getStringList("emergency effects", EFFECTSCATEGORY, Configs.defaultEmergencyEffect(), "Sets effects for emergency phase. format : effectId;duration;amplifier;show_icon")) {
                Configs.readEffectConfig(effect, emergencyEffects);
            }
            dangerousEffects = new ArrayList<PotionEffect>();
            for (String effect : dangerousEffectsStrings = configs.getStringList("dangerous effects", EFFECTSCATEGORY, Configs.defaultDangerousEffect(), "Sets effects for dangerous phase. format : effectId;duration;amplifier;show_icon")) {
                Configs.readEffectConfig(effect, dangerousEffects);
            }
            TimeIsUpEffects = new ArrayList<PotionEffect>();
            for (String effect : TimeIsUpEffectsStrings = configs.getStringList("time is up effects", EFFECTSCATEGORY, Configs.defaultTimeIsUpEffect(), "Sets effects for when the time is up. format : effectId;duration;amplifier;show_icon")) {
                Configs.readEffectConfig(effect, TimeIsUpEffects);
            }
        }
    }

    private static void deserializeDoomSpawners(List<? extends String> list) {
        DoomSpawners = new HashMap();
        for (String string : list) {
            String[] entries = string.split(";");
            ResourceLocation location = new ResourceLocation(entries[0]);
            ArrayList<Biome.SpawnListEntry> spawners = new ArrayList<Biome.SpawnListEntry>();
            for (int index = 1; index < entries.length; ++index) {
                String[] data = entries[index].split(",");
                Class entityType = EntityList.getClass((ResourceLocation)new ResourceLocation(data[0]));
                int weight = Integer.parseInt(data[1]);
                int minCount = Integer.parseInt(data[2]);
                int maxCount = Integer.parseInt(data[3]);
                if (entityType == null || !EntityLiving.class.isAssignableFrom(entityType)) continue;
                spawners.add(new Biome.SpawnListEntry(entityType, weight, minCount, maxCount));
            }
            DoomSpawners.put(location, spawners);
        }
    }

    private static void deserializeTimers(List<? extends String> list, int defaultAmountPerRecover) {
        for (String string : list) {
            String[] split = string.split(";");
            int key = Integer.parseInt(split[0]);
            basetimers.put(key, new Timer(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), split.length > 4 ? Integer.parseInt(split[4]) : defaultAmountPerRecover));
        }
    }

    private static void readEffectConfig(String effectStr, List<PotionEffect> list) {
        String[] values = effectStr.split(";");
        Potion effect = Potion.func_180142_b((String)values[0]);
        if (effect != null) {
            list.add(new PotionEffect(effect, Integer.parseInt(values[1]), Integer.parseInt(values[2]), true, Boolean.parseBoolean(values[3])));
        }
    }

    private static int[] defaultWarnings() {
        return new int[]{1220, 620};
    }

    private static int[] defaultBlackList() {
        return new int[]{0};
    }

    private static String[] defaultEmergencyEffect() {
        return new String[]{Configs.EffectToString(new PotionEffect(MobEffects.field_76421_d, 120, 1)), Configs.EffectToString(new PotionEffect(MobEffects.field_76419_f, 120, 0)), Configs.EffectToString(new PotionEffect(MobEffects.field_76436_u, 120, 0)), Configs.EffectToString(new PotionEffect(MobEffects.field_76438_s, 120, 0))};
    }

    private static String[] defaultDangerousEffect() {
        return new String[]{Configs.EffectToString(new PotionEffect(MobEffects.field_76421_d, 120, 1))};
    }

    private static String[] defaultTimeIsUpEffect() {
        return new String[]{Configs.EffectToString(new PotionEffect(MobEffects.field_76421_d, 120, 3)), Configs.EffectToString(new PotionEffect(MobEffects.field_76419_f, 120, 1)), Configs.EffectToString(new PotionEffect(MobEffects.field_76436_u, 120, 2)), Configs.EffectToString(new PotionEffect(MobEffects.field_76438_s, 120, 1))};
    }

    private static String EffectToString(PotionEffect effect) {
        String id = effect.func_188419_a().getRegistryName().toString();
        return id + ";" + effect.func_76459_b() + ";" + effect.func_76458_c() + ";" + effect.func_188418_e();
    }

    static {
        basetimers = new HashMap();
        configs = new Configuration(new File("config/time_is_up.cfg"));
    }
}

