/*
 * Decompiled with CFR 0.152.
 */
package timeisup.capabilities;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import timeisup.Configs;
import timeisup.ItemRegistry;
import timeisup.events.custom.TimeIsUpTickEvent;
import timeisup.network.PacketHandler;
import timeisup.network.TimerPacket;

public class Timer {
    public static final DamageSource TIME_IS_UP = new DamageSource("timeIsUp").func_76348_h().func_76359_i();
    private int tickDuration;
    private int tickRecover;
    private int tickPerDuration;
    private int maxDuration;
    private int amountPerRecover;
    private int potionTimer;

    public Timer(int baseTickDuration, int tickPerDuration, int maxDuration, int amountPerRecover) {
        this(baseTickDuration, tickPerDuration, maxDuration, 0, amountPerRecover);
    }

    public Timer(int baseTickDuration, int tickPerDuration, int maxDuration, int tickRecover, int amountPerRecover) {
        this.tickDuration = baseTickDuration;
        this.tickPerDuration = tickPerDuration;
        this.tickRecover = tickRecover;
        this.maxDuration = maxDuration;
        this.amountPerRecover = amountPerRecover;
        this.potionTimer = 1;
    }

    public void recover() {
        if (this.tickDuration >= this.maxDuration) {
            return;
        }
        ++this.tickRecover;
        if (this.tickRecover >= this.tickPerDuration) {
            this.addDuration(this.amountPerRecover);
            this.tickRecover = 0;
        }
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getRecoverAmount() {
        return this.amountPerRecover;
    }

    public int getRecoverCooldown() {
        return this.tickPerDuration;
    }

    public void sync(EntityLivingBase entity) {
        PacketHandler.INSTANCE.sendTo((IMessage)new TimerPacket(this.tickDuration), (EntityPlayerMP)entity);
    }

    public void decrease(EntityLivingBase entity) {
        if (entity.func_70089_S()) {
            if (Configs.potionEffect) {
                --this.potionTimer;
            }
            if (this.tickDuration > 0) {
                PotionEffect exileInstance;
                if (this.tickDuration < Configs.emergency) {
                    if (!MinecraftForge.EVENT_BUS.post((Event)new TimeIsUpTickEvent.EmergencyEvent(entity.field_70170_p, (EntityPlayerMP)entity, this.tickDuration)) && this.potionTimer <= 0) {
                        this.potionTimer = Configs.cooldownEffects;
                        Timer.addEffects(entity, Configs.emergencyEffects);
                    }
                } else if (this.tickDuration < Configs.dangerous && !MinecraftForge.EVENT_BUS.post((Event)new TimeIsUpTickEvent.DangerousEvent(entity.field_70170_p, (EntityPlayerMP)entity, this.tickDuration)) && this.potionTimer <= 0) {
                    this.potionTimer = Configs.cooldownEffects;
                    Timer.addEffects(entity, Configs.dangerousEffects);
                }
                if ((exileInstance = entity.func_70660_b((Potion)ItemRegistry.exileEffect)) != null) {
                    this.tickDuration -= exileInstance.func_76458_c() + 1;
                    if (this.tickDuration < 1) {
                        this.tickDuration = 1;
                    }
                }
                --this.tickDuration;
                if (this.tickDuration % 600 == 0 && entity instanceof EntityPlayerMP) {
                    this.sync(entity);
                }
            } else {
                if (MinecraftForge.EVENT_BUS.post((Event)new TimeIsUpTickEvent.TimeIsUpEvent(entity.field_70170_p, (EntityPlayerMP)entity, this.tickDuration))) {
                    return;
                }
                if (this.potionTimer <= 0) {
                    this.potionTimer = Configs.cooldownEffects;
                    Timer.addEffects(entity, Configs.TimeIsUpEffects);
                } else if (!Configs.potionEffect) {
                    entity.func_70097_a(TIME_IS_UP, Float.MAX_VALUE);
                }
            }
        }
    }

    public int getDuration() {
        return this.tickDuration;
    }

    public void addDuration(int duration) {
        this.tickDuration += duration;
    }

    public void writeNBT(String key, NBTTagCompound nbt) {
        nbt.func_74783_a(key, new int[]{this.tickDuration, this.tickPerDuration, this.maxDuration, this.tickRecover, this.amountPerRecover});
    }

    public static Timer fromData(int worldkey, int ... data) {
        Timer timer = Configs.basetimers.getOrDefault(worldkey, Configs.defaultTimer.copy()).copy();
        timer.tickRecover = data[3];
        timer.tickDuration = data[0];
        return timer;
    }

    public Timer copy() {
        return new Timer(this.tickDuration, this.tickPerDuration, this.maxDuration, this.amountPerRecover);
    }

    private static PotionEffect copyEffect(PotionEffect effect) {
        return new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
    }

    private static void addEffects(EntityLivingBase entity, List<PotionEffect> instances) {
        for (PotionEffect effect : instances) {
            entity.func_70690_d(Timer.copyEffect(effect));
        }
    }
}

