/*
 * Decompiled with CFR 0.152.
 */
package timeisup.capabilities;

import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import timeisup.Configs;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.network.PacketHandler;
import timeisup.network.WardPacket;

public class TimerCapability
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public HashMap<Integer, Timer> timers = new HashMap();
    public int ward = 0;
    private boolean boss_killed = false;
    public Timer global = null;

    public void Tick(int currentDimensionKey, EntityLivingBase entity) {
        if (this.boss_killed) {
            return;
        }
        if (!Configs.globalTimer) {
            this.timers.forEach((k, timer) -> {
                boolean isCurrent;
                boolean bl = isCurrent = k == currentDimensionKey;
                if (isCurrent && this.ward <= 0) {
                    timer.decrease(entity);
                } else {
                    timer.recover();
                }
            });
        } else if (Configs.blacklist.contains(currentDimensionKey) || this.ward > 0) {
            this.global.recover();
        } else {
            this.global.decrease(entity);
        }
        if (this.ward > 0) {
            --this.ward;
            if (this.ward == 0) {
                PacketHandler.INSTANCE.sendTo((IMessage)new WardPacket(false), (EntityPlayerMP)entity);
            }
        }
    }

    public void bossKilled() {
        this.boss_killed = true;
    }

    public boolean isBossKilled() {
        return this.boss_killed;
    }

    public Timer getOrCreate(int currentDimensionKey) {
        if (Configs.globalTimer && this.global == null) {
            this.global = Configs.defaultTimer.copy();
        }
        if (Configs.blacklist.contains(currentDimensionKey) || this.boss_killed) {
            return null;
        }
        if (Configs.globalTimer) {
            return this.global;
        }
        if (!this.timers.containsKey(currentDimensionKey)) {
            Timer timer = Configs.basetimers.getOrDefault(currentDimensionKey, Configs.defaultTimer.copy());
            this.timers.put(currentDimensionKey, timer);
            return timer;
        }
        return this.timers.get(currentDimensionKey);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == TimeIsUp.TIMER;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(TimerCapability.class, (Capability.IStorage)new TimerStorage(), TimerCapability::new);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)TimeIsUp.TIMER.getStorage().writeNBT(TimeIsUp.TIMER, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        TimeIsUp.TIMER.getStorage().readNBT(TimeIsUp.TIMER, (Object)this, null, (NBTBase)nbt);
    }

    public static class TimerStorage
    implements Capability.IStorage<TimerCapability> {
        public NBTBase writeNBT(Capability<TimerCapability> capability, TimerCapability instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (!instance.boss_killed) {
                NBTTagCompound worlds = new NBTTagCompound();
                instance.timers.forEach((k, timer) -> {
                    if (!Configs.blacklist.contains(k)) {
                        timer.writeNBT(k.toString(), worlds);
                    }
                });
                if (instance.global != null) {
                    instance.global.writeNBT("global_timer", nbt);
                }
                nbt.func_74782_a("worlds", (NBTBase)worlds);
            }
            nbt.func_74757_a("boss", instance.boss_killed);
            return nbt;
        }

        public void readNBT(Capability<TimerCapability> capability, TimerCapability instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            instance.boss_killed = compound.func_74767_n("boss");
            if (compound.func_74764_b("worlds") && !instance.boss_killed) {
                compound.func_74775_l("worlds").func_150296_c().forEach(key -> {
                    int[] data = compound.func_74775_l("worlds").func_74759_k(key);
                    int registrykey = Integer.parseInt(key);
                    instance.timers.put(registrykey, Timer.fromData(registrykey, data));
                });
            }
            if (compound.func_74764_b("global_timer")) {
                instance.global = Timer.fromData(0, compound.func_74759_k("global_timer"));
            }
        }
    }
}

