/*
 * Decompiled with CFR 0.152.
 */
package timeisup.effects;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import timeisup.Configs;

public class DoomEffect
extends Potion {
    private static final ResourceLocation ICON = new ResourceLocation("timeisup", "textures/mob_effect/doom_effect.png");

    public DoomEffect() {
        super(false, 15555380);
        this.setRegistryName("timeisup", "doom_effect");
        this.func_76390_b("timeisup.doom_effect");
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        mc.func_110434_K().func_110577_a(ICON);
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        mc.func_110434_K().func_110577_a(ICON);
        Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        int k = 80 >> amplifier;
        if (k > 0) {
            return duration % k == 0;
        }
        return true;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityPlayerMP) {
            WorldServer world = (WorldServer)entity.field_70170_p;
            Random rand = world.field_73012_v;
            if (rand.nextFloat() < Configs.mobSpawningChance) {
                Biome biome = world.func_180494_b(entity.func_180425_c());
                List<Biome.SpawnListEntry> spawners = Configs.DoomSpawners.get(biome.getRegistryName());
                if (spawners == null) {
                    spawners = Configs.DoomSpawners.get(new ResourceLocation(world.field_73011_w.func_186058_p().func_186065_b()));
                }
                if (spawners == null) {
                    spawners = biome.func_76747_a(EnumCreatureType.MONSTER);
                }
                Biome.SpawnListEntry spawner = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)rand, spawners);
                int k = spawner.field_76301_c + rand.nextInt(1 + spawner.field_76299_d - spawner.field_76301_c);
                for (int count = 0; count < k; ++count) {
                    EntityLiving mobentity;
                    int posX = (int)entity.field_70165_t + 8 - (int)(rand.nextFloat() * 16.0f);
                    int posZ = (int)entity.field_70161_v + 8 - (int)(rand.nextFloat() * 16.0f);
                    int posY = (int)entity.field_70163_u + 6 - (int)(rand.nextFloat() * 10.0f);
                    BlockPos pos = DoomEffect.getTopSolidOrLiquidBlock((World)world, new BlockPos(posX, posY, posZ));
                    if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)spawner.field_76300_b), (World)world, (BlockPos)pos)) {
                        return;
                    }
                    try {
                        mobentity = spawner.newInstance((World)world);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    mobentity.func_70012_b((double)posX, (double)pos.func_177956_o(), (double)posZ, rand.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)mobentity);
                    mobentity.func_180482_a(world.func_175649_E(new BlockPos((Entity)mobentity)), null);
                    mobentity.func_70624_b(entity);
                }
            }
        }
    }

    private static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), Math.min(chunk.func_76625_h() + 16, pos.func_177956_o()) + 1, pos.func_177952_p());
        int bottom = Math.max(0, pos.func_177956_o() - 12);
        IBlockState state = world.func_180495_p(blockpos);
        while (!state.func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && blockpos.func_177956_o() > bottom) {
            blockpos = blockpos.func_177977_b();
            state = world.func_180495_p(blockpos);
        }
        while (!state.func_185904_a().func_76230_c() && blockpos.func_177956_o() > 0) {
            blockpos = blockpos.func_177977_b();
            state = world.func_180495_p(blockpos);
        }
        return blockpos.func_177984_a();
    }
}

