/*
 * Decompiled with CFR 0.152.
 */
package timeisup.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import timeisup.Configs;
import timeisup.ItemRegistry;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.capabilities.TimerCapability;
import timeisup.network.PacketHandler;
import timeisup.network.RecoverRatePacket;
import timeisup.network.TimerPacket;

@Mod.EventBusSubscriber(modid="timeisup")
public class TimingEvent {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(new ResourceLocation("timeisup", "timeisup_timer"), (ICapabilityProvider)new TimerCapability());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        TimerCapability original = (TimerCapability)event.getOriginal().getCapability(TimeIsUp.TIMER, null);
        if (original != null) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            TimerCapability current = (TimerCapability)player.getCapability(TimeIsUp.TIMER, null);
            current.timers = original.timers;
            current.global = original.global;
            if (original.isBossKilled()) {
                current.bossKilled();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        TimerCapability cap;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && (cap = (TimerCapability)event.player.getCapability(TimeIsUp.TIMER, null)) != null && !event.player.func_184812_l_()) {
            cap.Tick(event.player.func_130014_f_().field_73011_w.getDimension(), (EntityLivingBase)event.player);
        }
    }

    @SubscribeEvent
    public static void onLivingKilled(LivingDeathEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (source instanceof EntityPlayerMP) {
            if (!Configs.blacklist.contains(source.field_70170_p.field_73011_w.getDimension()) && ((EntityPlayerMP)source).func_70681_au().nextFloat() < Configs.exileChance) {
                ((EntityPlayerMP)source).func_70690_d(new PotionEffect((Potion)ItemRegistry.exileEffect, 60, Configs.exileStrength, true, true));
            }
            if (Configs.boss != null) {
                NBTTagCompound entityNbt = event.getEntityLiving().serializeNBT();
                for (String key : Configs.boss.func_150296_c()) {
                    if (entityNbt.func_74764_b(key) && Configs.boss.func_74781_a(key).equals((Object)entityNbt.func_74781_a(key))) continue;
                    return;
                }
                TimerCapability cap = (TimerCapability)source.getCapability(TimeIsUp.TIMER, null);
                if (cap != null && !cap.isBossKilled()) {
                    source.func_145747_a((ITextComponent)new TextComponentString(Configs.bossMessage));
                    cap.bossKilled();
                    cap.ward = 0;
                    PacketHandler.INSTANCE.sendTo((IMessage)new TimerPacket(-1), (EntityPlayerMP)source);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        TimerCapability cap;
        if (event.getEntity() instanceof EntityPlayerMP && (cap = (TimerCapability)event.getEntity().getCapability(TimeIsUp.TIMER, null)) != null) {
            Timer timer = cap.getOrCreate(event.getWorld().field_73011_w.getDimension());
            int duration = -1;
            if (timer != null) {
                duration = timer.getDuration();
                PacketHandler.INSTANCE.sendTo((IMessage)new RecoverRatePacket(timer.getMaxDuration(), timer.getRecoverAmount(), timer.getRecoverCooldown()), (EntityPlayerMP)event.getEntity());
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new TimerPacket(duration), (EntityPlayerMP)event.getEntity());
        }
    }
}

