/*
 * Decompiled with CFR 0.152.
 */
package timeisup.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import timeisup.Configs;
import timeisup.ItemRegistry;

@Mod.EventBusSubscriber(modid="timeisup", value={Side.CLIENT})
public class TimingEventClient {
    private static final ResourceLocation CLOCK = new ResourceLocation("timeisup", "textures/gui/clock.png");
    private static final ResourceLocation VIGNETTE_TEX_PATH = new ResourceLocation("timeisup", "textures/misc/vignette.png");
    private static final ResourceLocation WARD_VIGNETTE_TEX_PATH = new ResourceLocation("timeisup", "textures/misc/ward_vignette.png");
    private static final ResourceLocation END_WARD_VIGNETTE_TEX_PATH = new ResourceLocation("timeisup", "textures/misc/end_ward_vignette.png");
    public static int ticksDuration = -1;
    public static int ward = 0;
    public static boolean warded = false;
    public static int recovered = 0;
    public static int cooldown = 0;
    public static int maxDuration = 0;
    private static int ticksRecover = 0;

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            warded = false;
        }
    }

    @SubscribeEvent
    public static void TimerDraw(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && ticksDuration > -1) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            String timer = StringUtils.func_76337_a((int)ticksDuration);
            ScaledResolution window = event.getResolution();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            if (ward > 0) {
                if (ward >= 35) {
                    TimingEventClient.drawVignette(window, mc, 0xDDAA22, (float)(70 - ward) / 35.0f, warded ? WARD_VIGNETTE_TEX_PATH : END_WARD_VIGNETTE_TEX_PATH);
                } else {
                    TimingEventClient.drawVignette(window, mc, 0xDDAA22, (float)ward / 35.0f, warded ? WARD_VIGNETTE_TEX_PATH : END_WARD_VIGNETTE_TEX_PATH);
                }
            }
            if (ticksDuration >= Configs.dangerous) {
                TimingEventClient.drawClock(5, window.func_78328_b() - (font.field_78288_b + 5), 0.3f, mc);
                font.func_78276_b((warded ? TextFormatting.GOLD : TextFormatting.DARK_GREEN) + timer, 18, window.func_78328_b() - (font.field_78288_b + 4), 0);
            } else {
                TimingEventClient.drawVignette(window, mc, mc.field_71441_e.func_180494_b(mc.field_71439_g.func_180425_c()).func_180625_c(mc.field_71439_g.func_180425_c()), (float)(Configs.dangerous - ticksDuration) / (float)Configs.dangerous, VIGNETTE_TEX_PATH);
                if (ticksDuration >= Configs.emergency) {
                    TimingEventClient.drawClock(5, window.func_78328_b() - (font.field_78288_b + 5), 0.3f, mc);
                    font.func_78276_b((warded ? TextFormatting.GOLD : TextFormatting.RED) + timer, 18, window.func_78328_b() - (font.field_78288_b + 4), 0);
                } else if (ticksDuration > 0) {
                    GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                    TimingEventClient.drawClock(window.func_78326_a() / 8 - (font.func_78256_a(timer) - 1) / 2 - 6, window.func_78328_b() / 14 - font.field_78288_b / 2, 0.3f, mc);
                    font.func_175063_a((warded ? TextFormatting.GOLD : TextFormatting.DARK_RED) + StringUtils.func_76337_a((int)ticksDuration), (float)(window.func_78326_a() / 8 - (font.func_78256_a(timer) - 1) / 2 + 6), (float)(window.func_78328_b() / 14 - font.field_78288_b / 2 + 1), 0);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private static void drawClock(int left, int top, float scale, Minecraft mc) {
        mc.func_110434_K().func_110577_a(CLOCK);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        Gui.func_146110_a((int)((int)((float)left / scale)), (int)((int)((float)top / scale)), (float)32.0f, (float)32.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.CLIENT) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (event.player == player) {
                if (!player.func_184812_l_()) {
                    if (warded) {
                        if (ticksDuration < maxDuration && ++ticksRecover >= cooldown) {
                            ticksRecover = 0;
                            ticksDuration += recovered;
                        }
                    } else if (ticksDuration > 0) {
                        PotionEffect exileInstance;
                        if (Configs.warnings.stream().anyMatch(tick -> tick == ticksDuration) || ticksDuration <= Configs.emergency && ticksDuration % 20 == 0) {
                            mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 1.1f, 0.5f, player.func_180425_c()));
                        }
                        if ((exileInstance = player.func_70660_b((Potion)ItemRegistry.exileEffect)) != null) {
                            ticksDuration -= exileInstance.func_76458_c() + 1;
                        }
                        --ticksDuration;
                    }
                }
                if (ward > 0) {
                    if (ward == 65) {
                        mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(warded ? SoundEvents.field_187548_af : SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 0.8f, 1.0f, player.func_180425_c()));
                    }
                    --ward;
                }
            }
        }
    }

    private static void drawVignette(ScaledResolution window, Minecraft mc, int color, float alpha, ResourceLocation picture) {
        mc.func_110434_K().func_110577_a(picture);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        TimingEventClient.innerBlit(0, window.func_78326_a(), 0, window.func_78328_b(), -90, 0.0f, 1.0f, 0.0f, 1.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, alpha);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    private static void innerBlit(int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float r, float g, float b, float alpha) {
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(alpha * 1.25f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x1, (double)y2, (double)blitOffset).func_187315_a((double)minU, (double)maxV).func_181675_d();
        bufferbuilder.func_181662_b((double)x2, (double)y2, (double)blitOffset).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        bufferbuilder.func_181662_b((double)x2, (double)y1, (double)blitOffset).func_187315_a((double)maxU, (double)minV).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y1, (double)blitOffset).func_187315_a((double)minU, (double)minV).func_181675_d();
        GlStateManager.func_179141_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public static void modelRegistry(ModelRegistryEvent ev) {
        TimingEventClient.registerItem(ItemRegistry.ward_item);
        TimingEventClient.registerItem(ItemRegistry.timer_anchor);
        TimingEventClient.registerItem(ItemRegistry.timer_bonus);
        TimingEventClient.registerItem(ItemRegistry.ward_head);
    }

    private static void registerItem(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }
}

