/*
 * Decompiled with CFR 0.152.
 */
package timeisup.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.capabilities.TimerCapability;
import timeisup.events.TimingEventClient;
import timeisup.network.PacketHandler;
import timeisup.network.TimerPacket;

public class TimerAnchor
extends Item {
    public TimerAnchor() {
        this.setRegistryName("timeisup", "timer_anchor");
        this.func_77655_b("timeisup.timer_anchor");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77656_e(11);
    }

    private int getDuration(NBTTagCompound nbt, World worldIn, EntityPlayer playerIn, int current_duration) {
        if (nbt.func_186855_b("anchor_player") && playerIn.func_110124_au().equals(nbt.func_186857_a("anchor_player")) && nbt.func_150297_b("anchor", 99) && nbt.func_150297_b("anchor_dim", 99)) {
            int dim_id = nbt.func_74762_e("anchor_dim");
            if (worldIn.field_73011_w.getDimension() == dim_id) {
                int time = nbt.func_74762_e("anchor");
                return time - current_duration;
            }
        }
        return 0;
    }

    private NBTTagList newDoubleNBTList(double ... numbers) {
        NBTTagList listnbt = new NBTTagList();
        for (double d0 : numbers) {
            listnbt.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return listnbt;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        Timer player_timer;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        TimerCapability cap = (TimerCapability)playerIn.getCapability(TimeIsUp.TIMER, null);
        if (cap != null && (player_timer = cap.getOrCreate(worldIn.field_73011_w.getDimension())) != null) {
            int substract_duration;
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = itemstack.func_77978_p();
            if (itemstack.func_77952_i() < itemstack.func_77958_k() - 1 && (substract_duration = this.getDuration(nbt, worldIn, playerIn, player_timer.getDuration())) > 0 && nbt.func_150297_b("anchor_pos", 9)) {
                NBTTagList listnbt = nbt.func_150295_c("anchor_pos", 6);
                playerIn.func_70634_a(listnbt.func_150309_d(0), listnbt.func_150309_d(1), listnbt.func_150309_d(2));
                player_timer.addDuration(substract_duration / 2);
                PacketHandler.INSTANCE.sendTo((IMessage)new TimerPacket(player_timer.getDuration()), (EntityPlayerMP)playerIn);
                playerIn.func_184811_cZ().func_185145_a((Item)this, substract_duration * 2);
                itemstack.func_96631_a(1, worldIn.field_73012_v, (EntityPlayerMP)playerIn);
            } else if (playerIn.func_70093_af()) {
                nbt.func_186854_a("anchor_player", playerIn.func_110124_au());
                nbt.func_74768_a("anchor", player_timer.getDuration());
                nbt.func_74768_a("anchor_dim", worldIn.field_73011_w.getDimension());
                nbt.func_74782_a("anchor_pos", (NBTBase)this.newDoubleNBTList(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            tooltip.add(TextFormatting.GREEN + "Refill with " + I18n.func_74838_a((String)(Items.field_151079_bi.func_77658_a() + ".name")));
        } else if (worldIn != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int duration = 0;
            if (stack.func_77942_o()) {
                duration = this.getDuration(stack.func_77978_p(), worldIn, (EntityPlayer)mc.field_71439_g, TimingEventClient.ticksDuration);
            }
            if (duration != 0) {
                if (duration < 0) {
                    duration = 0;
                    tooltip.add(TextFormatting.GRAY + "Shift + right click to set to current timer");
                }
                tooltip.add(TextFormatting.GREEN + "Right click to recover " + StringUtils.func_76337_a((int)(duration / 2)));
                if (stack.func_77978_p().func_150297_b("anchor_pos", 9)) {
                    NBTTagList listnbt = stack.func_77978_p().func_150295_c("anchor_pos", 6);
                    tooltip.add(TextFormatting.GREEN + "and be teleported to" + TextFormatting.YELLOW + " " + (int)listnbt.func_150309_d(0) + " " + (int)listnbt.func_150309_d(1) + " " + (int)listnbt.func_150309_d(2));
                }
                tooltip.add(TextFormatting.GOLD + "Cooldown : " + StringUtils.func_76337_a((int)(duration * 2)));
            } else {
                tooltip.add(TextFormatting.GREEN + "Shift + right click to set to current timer");
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(stack.func_77952_i() + 1) / (double)stack.func_77958_k();
    }
}

