/*
 * Decompiled with CFR 0.152.
 */
package timeisup;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import timeisup.capabilities.Timer;

@Mod.EventBusSubscriber(modid="timeisup", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Configs {
    public static List<Integer> warnings;
    public static List<RegistryKey<World>> blacklist;
    public static int dangerous;
    public static int emergency;
    public static Timer defaultTimer;
    public static HashMap<RegistryKey<World>, Timer> basetimers;
    public static boolean potionEffect;
    public static boolean safeRespawn;
    public static List<EffectInstance> emergencyEffects;
    public static List<EffectInstance> dangerousEffects;
    public static List<EffectInstance> TimeIsUpEffects;
    public static int cooldownEffects;
    public static HashMap<ResourceLocation, List<MobSpawnInfo.Spawners>> DoomSpawners;
    public static float mobSpawningChance;
    public static float exileChance;
    public static int exileStrength;
    public static CompoundNBT boss;
    public static String bossMessage;
    public static boolean globalTimer;
    public static final ServerConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            Configs.bakeConfig();
        }
    }

    public static void bakeConfig() {
        warnings = (List)Configs.COMMON.warnings.get();
        dangerous = (Integer)Configs.COMMON.dangerous.get();
        emergency = (Integer)Configs.COMMON.emergency.get();
        defaultTimer = new Timer((Integer)Configs.COMMON.defaultDuration.get(), (Integer)Configs.COMMON.defaultTickPerDuration.get(), (Integer)Configs.COMMON.defaultMaxDuration.get(), (Integer)Configs.COMMON.defaultAmountPerRecover.get());
        globalTimer = (Boolean)Configs.COMMON.globalTimer.get();
        blacklist = ((List)Configs.COMMON.blacklist.get()).stream().map(id -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(id))).collect(Collectors.toList());
        Configs.deserializeTimers((List)Configs.COMMON.defaultTimers.get());
        exileChance = ((Double)Configs.COMMON.exileChance.get()).floatValue();
        exileStrength = (Integer)Configs.COMMON.exileStrength.get();
        safeRespawn = (Boolean)Configs.COMMON.safeRespawn.get();
        Configs.deserializeDoomSpawners((List)Configs.COMMON.DoomSpawners.get());
        mobSpawningChance = ((Double)Configs.COMMON.mobSpawningChance.get()).floatValue();
        bossMessage = (String)Configs.COMMON.bossMessage.get();
        String strboss = (String)Configs.COMMON.boss.get();
        if (!strboss.isEmpty()) {
            try {
                boss = JsonToNBT.func_180713_a((String)((String)Configs.COMMON.boss.get()));
            }
            catch (CommandSyntaxException e1) {
                e1.printStackTrace();
            }
        }
        cooldownEffects = (Integer)Configs.COMMON.cooldownEffects.get();
        potionEffect = (Boolean)Configs.COMMON.potionEffect.get();
        try {
            Configs.setEffects();
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }

    private static void setEffects() throws CommandSyntaxException {
        if (potionEffect) {
            emergencyEffects = new ArrayList<EffectInstance>();
            for (String effect : (List)Configs.COMMON.emergencyEffects.get()) {
                Configs.readEffectConfig(effect, emergencyEffects);
            }
            dangerousEffects = new ArrayList<EffectInstance>();
            for (String effect : (List)Configs.COMMON.dangerousEffects.get()) {
                Configs.readEffectConfig(effect, dangerousEffects);
            }
            TimeIsUpEffects = new ArrayList<EffectInstance>();
            for (String effect : (List)Configs.COMMON.TimeIsUpEffects.get()) {
                Configs.readEffectConfig(effect, TimeIsUpEffects);
            }
        }
    }

    private static void deserializeDoomSpawners(List<? extends String> list) {
        DoomSpawners = new HashMap();
        for (String string : list) {
            String[] entries = string.split(";");
            ResourceLocation location = new ResourceLocation(entries[0]);
            ArrayList<MobSpawnInfo.Spawners> spawners = new ArrayList<MobSpawnInfo.Spawners>();
            for (int index = 1; index < entries.length; ++index) {
                String[] data = entries[index].split(",");
                EntityType entityType = EntityType.func_220327_a((String)data[0]).orElse(null);
                int weight = Integer.parseInt(data[1]);
                int minCount = Integer.parseInt(data[2]);
                int maxCount = Integer.parseInt(data[3]);
                if (entityType == null) continue;
                spawners.add(new MobSpawnInfo.Spawners(entityType, weight, minCount, maxCount));
            }
            DoomSpawners.put(location, spawners);
        }
    }

    private static void deserializeTimers(List<? extends String> list) {
        for (String string : list) {
            String[] split = string.split(";");
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(split[0]));
            basetimers.put((RegistryKey<World>)key, new Timer(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), split.length > 4 ? Integer.parseInt(split[4]) : (Integer)Configs.COMMON.defaultAmountPerRecover.get()));
        }
    }

    private static void readEffectConfig(String effectStr, List<EffectInstance> list) {
        String[] values = effectStr.split(";");
        Effect effect = (Effect)Registry.field_212631_t.func_82594_a(new ResourceLocation(values[0]));
        if (effect != null) {
            list.add(new EffectInstance(effect, Integer.parseInt(values[1]), Integer.parseInt(values[2]), true, Boolean.parseBoolean(values[3])));
        }
    }

    static {
        basetimers = new HashMap();
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<List<Integer>> warnings;
        public final ForgeConfigSpec.IntValue dangerous;
        public final ForgeConfigSpec.IntValue emergency;
        public final ForgeConfigSpec.ConfigValue<List<String>> blacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> defaultTimers;
        public final ForgeConfigSpec.IntValue defaultDuration;
        public final ForgeConfigSpec.IntValue defaultTickPerDuration;
        public final ForgeConfigSpec.IntValue defaultMaxDuration;
        public final ForgeConfigSpec.IntValue defaultAmountPerRecover;
        public final ForgeConfigSpec.BooleanValue globalTimer;
        public final ForgeConfigSpec.BooleanValue potionEffect;
        public final ForgeConfigSpec.BooleanValue safeRespawn;
        public final ForgeConfigSpec.ConfigValue<String> boss;
        public final ForgeConfigSpec.ConfigValue<String> bossMessage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> emergencyEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dangerousEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> TimeIsUpEffects;
        public final ForgeConfigSpec.IntValue cooldownEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> DoomSpawners;
        public final ForgeConfigSpec.DoubleValue mobSpawningChance;
        public final ForgeConfigSpec.DoubleValue exileChance;
        public final ForgeConfigSpec.IntValue exileStrength;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"All values are calculated in minecraft ticks,", "20 ticks = 1 second.", "The timer always displays complete remaining seconds,", "so 620 ticks = 30 seconds displayed by the timer."});
            builder.push("Configs");
            this.safeRespawn = builder.comment(new String[]{"The player respawns at default spawnpoint if their spawnpoint is set to a dimension with little time left.", "Set to false to disable this."}).define("Safe Respawn", true);
            this.potionEffect = builder.comment("When time is up, the player die if set to false or receive bad potion effects if set to true").define("Potion Effects", false);
            this.defaultDuration = builder.comment("Default duration when the player comes for the first time in this dimension. [default:12000 = 10 minutes]").defineInRange("Default duration", 12000, 0, Integer.MAX_VALUE);
            this.defaultTickPerDuration = builder.comment("Default tick amount to spend in an other dimension to recover ticks in this dimension. [default:4]").defineInRange("Default ticks per duration", 4, 1, Integer.MAX_VALUE);
            this.defaultMaxDuration = builder.comment("Default max duration that can be accumulated for a dimension. [default:72000 = 1 hour]").defineInRange("Default max duration", 72000, 0, Integer.MAX_VALUE);
            this.defaultAmountPerRecover = builder.comment("Default amount of ticks recovered per tick recover. [default:1]").defineInRange("Default amount recovered", 1, 1, Integer.MAX_VALUE);
            this.warnings = builder.comment("Play a warning sound at these ticks. [default: [1220, 620] ]").define("Warnings", ServerConfig.defaultWarnings());
            this.dangerous = builder.comment("Tick when the timer becomes red. [default:620]").defineInRange("Dangerous", 620, 0, Integer.MAX_VALUE);
            this.emergency = builder.comment("Tick when the timer comes in the front of the screen [default:220]").defineInRange("Emergency", 220, 0, Integer.MAX_VALUE);
            this.blacklist = builder.comment("Dimensions where there is NO timer").define("BlackList", ServerConfig.defaultBlackList());
            this.globalTimer = builder.comment("Set to true to use the same shared timer for all dimensions").define("Global timer", false);
            this.defaultTimers = builder.comment(new String[]{"Default timer for each dimension.", "Format for one dimension : \"dimension_id;default_duration;ticks_per_duration;max_duration;amount_recovered\".", "Example : \"minecraft:the_nether;12000;4;72000;3\""}).defineList("Default timers", new ArrayList(), ServerConfig::validateTimers);
            builder.pop();
            builder.push("Boss");
            this.boss = builder.comment(new String[]{"NBT of the boss.", "Every entity matching this NBT is considered as boss.", "Once the player has killed the boss, his timers are disabled.", "Leaving this blank will disable boss functionality."}).define("Boss", (Object)"{id:'minecraft:ender_dragon'}");
            this.bossMessage = builder.comment("Message sent when the player killed the boss.").define("Boss message", (Object)"\u00a76You are now free to travel across dimensions without any limit.");
            builder.pop();
            builder.push("Effects");
            this.emergencyEffects = builder.comment("Sets effects for emergency phase. format : effectId;duration;amplifier;show_icon").defineList("emergency effects", ServerConfig.defaultEmergencyEffect(), ServerConfig::validateEffects);
            this.dangerousEffects = builder.comment("Sets effects for dangerous phase. format : effectId;duration;amplifier;show_icon").defineList("dangerous effects", ServerConfig.defaultDangerousEffect(), ServerConfig::validateEffects);
            this.TimeIsUpEffects = builder.comment("Sets effects for when the time is up. format : effectId;duration;amplifier;show_icon").defineList("time is up effects", ServerConfig.defaultTimeIsUpEffect(), ServerConfig::validateEffects);
            this.cooldownEffects = builder.comment("Cooldown before applying effects. [80 ticks by default]").defineInRange("effects cooldown", 80, 1, Integer.MAX_VALUE);
            this.exileChance = builder.comment("Chances to get Exile Effect by killing a mob.").defineInRange("Exile chances", 0.05, 0.0, 1.0);
            this.exileStrength = builder.comment("Exile Effect amplifier").defineInRange("Exile amplifier", 0, 0, 255);
            this.DoomSpawners = builder.comment(new String[]{"Sets mobs that can be spawned by doom effect.", "If a dimension or biome is not set, default spawnset for biome will be used.", "format :  dimension_or_biome_name;entry1;entry2; ...", "entry format : entity_name,weight,minCount,maxCount", "weight - higher weight mean higher chance to spawn", "minCount - minimum group size", "maxCount - maximum group size"}).defineList("Doom spawners", new ArrayList(), ServerConfig::validateSpawners);
            this.mobSpawningChance = builder.comment(new String[]{"Sets the spawn chance when doom performs its effect.", "Assuming nothing else is preventing spawning."}).defineInRange("Doom spawn chance", 0.6, 0.0, 1.0);
            builder.pop();
        }

        private static boolean validateTimers(Object o) {
            return o == null || ((String)o).split(";").length >= 4;
        }

        private static boolean validateEffects(Object o) {
            return o == null || ((String)o).contains(";") && ((String)o).split(";").length == 4;
        }

        private static boolean validateSpawners(Object o) {
            if (o == null) {
                return true;
            }
            if (((String)o).contains(";")) {
                String[] entries = ((String)o).split(";");
                for (int index = 1; index < entries.length; ++index) {
                    if (entries[index].contains(",") && entries[index].split(",").length == 4) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static ArrayList<Integer> defaultWarnings() {
            ArrayList<Integer> warnings = new ArrayList<Integer>();
            warnings.add(1220);
            warnings.add(620);
            return warnings;
        }

        private static ArrayList<String> defaultBlackList() {
            ArrayList<String> blacklist = new ArrayList<String>();
            blacklist.add(World.field_234918_g_.func_240901_a_().toString());
            return blacklist;
        }

        private static ArrayList<String> defaultEmergencyEffect() {
            ArrayList<String> effects = new ArrayList<String>();
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76421_d, 120, 1)));
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76419_f, 120, 0)));
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76436_u, 120, 0)));
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76438_s, 120, 0)));
            return effects;
        }

        private static ArrayList<String> defaultDangerousEffect() {
            ArrayList<String> effects = new ArrayList<String>();
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76421_d, 120, 1)));
            return effects;
        }

        private static ArrayList<String> defaultTimeIsUpEffect() {
            ArrayList<String> effects = new ArrayList<String>();
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76421_d, 120, 3)));
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76419_f, 120, 1)));
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76436_u, 120, 2)));
            effects.add(ServerConfig.EffectToString(new EffectInstance(Effects.field_76438_s, 120, 1)));
            return effects;
        }

        private static String EffectToString(EffectInstance effect) {
            String id = effect.func_188419_a().getRegistryName().toString();
            return id + ";" + effect.func_76459_b() + ";" + effect.func_76458_c() + ";" + effect.func_205348_f();
        }
    }
}

