/*
 * Decompiled with CFR 0.152.
 */
package timeisup.capabilities;

import java.util.HashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import timeisup.Configs;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.compat.gamestages.BridgeUtils;
import timeisup.network.PacketHandler;
import timeisup.network.WardPacket;

public class TimerCapability
implements ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    public HashMap<RegistryKey<World>, Timer> timers = new HashMap();
    public int ward = 0;
    private LazyOptional<TimerCapability> instance = LazyOptional.of(() -> (TimerCapability)TimeIsUp.TIMER.getDefaultInstance());
    private boolean boss_killed = false;
    public Timer global = null;

    public void Tick(RegistryKey<World> currentDimensionKey, LivingEntity entity) {
        if (this.boss_killed) {
            return;
        }
        if (!Configs.globalTimer) {
            this.timers.forEach((k, timer) -> {
                boolean isCurrent;
                boolean bl = isCurrent = k == currentDimensionKey;
                if (isCurrent && this.ward <= 0) {
                    if (!BridgeUtils.isDimensionUnlocked(currentDimensionKey, (PlayerEntity)entity)) {
                        timer.decrease(entity);
                    }
                } else {
                    timer.recover();
                }
            });
        } else if (Configs.blacklist.contains(currentDimensionKey) || this.ward > 0) {
            this.global.recover();
        } else {
            this.global.decrease(entity);
        }
        if (this.ward > 0) {
            --this.ward;
            if (this.ward == 0) {
                PacketHandler.INSTANCE.sendTo((Object)new WardPacket(false), ((ServerPlayerEntity)entity).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void bossKilled() {
        this.boss_killed = true;
    }

    public boolean isBossKilled() {
        return this.boss_killed;
    }

    public Timer getOrCreate(RegistryKey<World> currentDimensionKey, PlayerEntity player) {
        if (Configs.globalTimer && this.global == null) {
            this.global = Configs.defaultTimer.copy();
        }
        if (Configs.blacklist.contains(currentDimensionKey) || this.boss_killed || BridgeUtils.isDimensionUnlocked(currentDimensionKey, player)) {
            return null;
        }
        if (Configs.globalTimer) {
            return this.global;
        }
        if (!this.timers.containsKey(currentDimensionKey)) {
            Timer timer = Configs.basetimers.getOrDefault(currentDimensionKey, Configs.defaultTimer.copy());
            this.timers.put(currentDimensionKey, timer);
            return timer;
        }
        return this.timers.get(currentDimensionKey);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        return TimeIsUp.TIMER.orEmpty(capability, this.instance);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(TimerCapability.class, (Capability.IStorage)new TimerStorage(), TimerCapability::new);
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)TimeIsUp.TIMER.getStorage().writeNBT(TimeIsUp.TIMER, this.instance.orElse(null), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        TimeIsUp.TIMER.getStorage().readNBT(TimeIsUp.TIMER, this.instance.orElse(null), null, (INBT)nbt);
    }

    public static class TimerStorage
    implements Capability.IStorage<TimerCapability> {
        public INBT writeNBT(Capability<TimerCapability> capability, TimerCapability instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            if (!instance.boss_killed) {
                CompoundNBT worlds = new CompoundNBT();
                instance.timers.forEach((k, timer) -> {
                    if (!Configs.blacklist.contains(k)) {
                        timer.writeNBT(k.func_240901_a_().toString(), worlds);
                    }
                });
                if (instance.global != null) {
                    instance.global.writeNBT("global_timer", nbt);
                }
                nbt.func_218657_a("worlds", (INBT)worlds);
            }
            nbt.func_74757_a("boss", instance.boss_killed);
            return nbt;
        }

        public void readNBT(Capability<TimerCapability> capability, TimerCapability instance, Direction side, INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            instance.boss_killed = compound.func_74767_n("boss");
            if (compound.func_74764_b("worlds") && !instance.boss_killed) {
                compound.func_74775_l("worlds").func_150296_c().forEach(key -> {
                    int[] data = compound.func_74775_l("worlds").func_74759_k(key);
                    RegistryKey registrykey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(key));
                    instance.timers.put((RegistryKey<World>)registrykey, Timer.fromData((RegistryKey<World>)registrykey, data));
                });
            }
            if (compound.func_74764_b("global_timer")) {
                instance.global = Timer.fromData(null, compound.func_74759_k("global_timer"));
            }
        }
    }
}

