/*
 * Decompiled with CFR 0.152.
 */
package timeisup.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import timeisup.Configs;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.capabilities.TimerCapability;
import timeisup.network.PacketHandler;
import timeisup.network.TimerPacket;

public class TimerCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"timer").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> TimerCommand.setTimer((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), EntityArgument.func_197090_e((CommandContext)context, (String)"player")))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> TimerCommand.setTimer((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"))))))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"time", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TimerCommand.addTimer((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), EntityArgument.func_197090_e((CommandContext)context, (String)"player")))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> TimerCommand.addTimer((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"))))))));
    }

    public static int setTimer(CommandSource sender, int time, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            TimerCommand.setDuration(sender, time, player, player.func_71121_q(), true);
        }
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.timeisup.settimer", new Object[]{time}), true);
        return 1;
    }

    public static int setTimer(CommandSource sender, int time, Collection<ServerPlayerEntity> players, ServerWorld world) {
        if (Configs.blacklist.contains(world.func_234923_W_())) {
            sender.func_197021_a((ITextComponent)new TranslationTextComponent("commands.timeisup.timerblacklist", new Object[]{world.func_234923_W_().func_240901_a_()}));
            return 0;
        }
        for (ServerPlayerEntity player : players) {
            TimerCommand.setDuration(sender, time, player, world, world == player.func_71121_q());
        }
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.timeisup.settimerdim", new Object[]{world.func_234923_W_().func_240901_a_(), time}), true);
        return 1;
    }

    public static int addTimer(CommandSource sender, int time, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            TimerCommand.addDuration(sender, time, player, player.func_71121_q(), true);
        }
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.timeisup.addtimer", new Object[]{time}), true);
        return 1;
    }

    public static int addTimer(CommandSource sender, int time, Collection<ServerPlayerEntity> players, ServerWorld world) {
        if (Configs.blacklist.contains(world.func_234923_W_())) {
            sender.func_197021_a((ITextComponent)new TranslationTextComponent("commands.timeisup.timerblacklist", new Object[]{world.func_234923_W_().func_240901_a_()}));
            return 0;
        }
        for (ServerPlayerEntity player : players) {
            TimerCommand.addDuration(sender, time, player, world, world == player.func_71121_q());
        }
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.timeisup.addtimerdim", new Object[]{time, world.func_234923_W_().func_240901_a_()}), true);
        return 1;
    }

    public static void setDuration(CommandSource sender, int time, ServerPlayerEntity player, ServerWorld world, boolean send) {
        Timer dimTimer;
        TimerCapability timer = (TimerCapability)player.getCapability(TimeIsUp.TIMER, null).orElse(null);
        if (timer != null && (dimTimer = timer.getOrCreate((RegistryKey<World>)world.func_234923_W_(), (PlayerEntity)player)) != null) {
            dimTimer.setDuration(time);
            if (send) {
                PacketHandler.INSTANCE.sendTo((Object)new TimerPacket(time), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public static void addDuration(CommandSource sender, int time, ServerPlayerEntity player, ServerWorld world, boolean send) {
        Timer dimTimer;
        TimerCapability timer = (TimerCapability)player.getCapability(TimeIsUp.TIMER, null).orElse(null);
        if (timer != null && (dimTimer = timer.getOrCreate((RegistryKey<World>)world.func_234923_W_(), (PlayerEntity)player)) != null) {
            if (-time > dimTimer.getDuration()) {
                time = -dimTimer.getDuration();
            }
            dimTimer.addDuration(time);
            if (send) {
                PacketHandler.INSTANCE.sendTo((Object)new TimerPacket(dimTimer.getDuration()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

