/*
 * Decompiled with CFR 0.152.
 */
package timeisup.effects;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import timeisup.Configs;

public class DoomEffect
extends Effect {
    public DoomEffect() {
        super(EffectType.NEUTRAL, 15555380);
        this.setRegistryName("timeisup", "doom_effect");
    }

    public boolean func_76397_a(int duration, int amplifier) {
        int k = 80 >> amplifier;
        if (k > 0) {
            return duration % k == 0;
        }
        return true;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        ServerWorld world;
        Random rand;
        if (entity instanceof ServerPlayerEntity && (rand = (world = (ServerWorld)entity.field_70170_p).func_201674_k()).nextFloat() < Configs.mobSpawningChance) {
            Biome biome = world.func_226691_t_(entity.func_233580_cy_());
            List spawners = Configs.DoomSpawners.get(biome.getRegistryName());
            if (spawners == null) {
                spawners = Configs.DoomSpawners.get(world.func_234923_W_().func_240901_a_());
            }
            if (spawners == null) {
                spawners = biome.func_242433_b().func_242559_a(EntityClassification.MONSTER);
            }
            MobSpawnInfo.Spawners spawner = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)rand, spawners);
            int k = spawner.field_242589_d + rand.nextInt(1 + spawner.field_242590_e - spawner.field_242589_d);
            for (int count = 0; count < k; ++count) {
                int posX = (int)entity.func_226277_ct_() + 8 - (int)(rand.nextFloat() * 16.0f);
                int posZ = (int)entity.func_226281_cx_() + 8 - (int)(rand.nextFloat() * 16.0f);
                int posY = (int)entity.func_226278_cu_() + 6 - (int)(rand.nextFloat() * 10.0f);
                float f = spawner.field_242588_c.func_220333_h();
                double d0 = MathHelper.func_151237_a((double)posX, (double)((double)((int)entity.func_226277_ct_()) - 8.0 + (double)f), (double)((double)((int)entity.func_226277_ct_()) + 8.0 - (double)f));
                double d1 = MathHelper.func_151237_a((double)posZ, (double)((double)((int)entity.func_226281_cx_()) - 8.0 + (double)f), (double)((double)((int)entity.func_226281_cx_()) + 8.0 - (double)f));
                BlockPos pos = DoomEffect.getTopSolidOrLiquidBlock((IWorldReader)world, spawner.field_242588_c, posX, posZ, posY);
                if (!world.func_226664_a_(spawner.field_242588_c.func_220328_a(d0, (double)pos.func_177956_o(), d1)) || !WorldEntitySpawner.canSpawnAtBody((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)spawner.field_242588_c), (IWorldReader)world, (BlockPos)new BlockPos(d0, (double)pos.func_177956_o(), d1), (EntityType)spawner.field_242588_c)) {
                    return;
                }
                MobEntity mobentity = (MobEntity)spawner.field_242588_c.func_200721_a((World)world);
                mobentity.func_70080_a(d0, (double)pos.func_177956_o(), d1, rand.nextFloat() * 360.0f, 0.0f);
                mobentity.func_213386_a((IServerWorld)world, world.func_175649_E(mobentity.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, (CompoundNBT)null);
                mobentity.func_70624_b(entity);
                world.func_217376_c((Entity)mobentity);
            }
        }
    }

    private static BlockPos getTopSolidOrLiquidBlock(IWorldReader world, EntityType<?> entityType, int x, int z, int top) {
        int i = Math.min(world.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(entityType), x, z), top);
        int bottom = Math.max(0, i - 12);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, i + 1, z);
        while (!world.func_180495_p((BlockPos)blockpos$mutable).func_196958_f() && blockpos$mutable.func_177956_o() > bottom) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        while (!world.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c() && blockpos$mutable.func_177956_o() > 0) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        return blockpos$mutable.func_177984_a();
    }
}

