/*
 * Decompiled with CFR 0.152.
 */
package timeisup.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import timeisup.Configs;
import timeisup.ItemRegistry;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.capabilities.TimerCapability;
import timeisup.network.PacketHandler;
import timeisup.network.RecoverRatePacket;
import timeisup.network.TimerPacket;

@Mod.EventBusSubscriber(modid="timeisup", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimingEvent {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayerEntity) {
            event.addCapability(new ResourceLocation("timeisup", "timeisup_timer"), (ICapabilityProvider)new TimerCapability());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        TimerCapability original = (TimerCapability)event.getOriginal().getCapability(TimeIsUp.TIMER).orElse(null);
        if (original != null) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            TimerCapability current = (TimerCapability)player.getCapability(TimeIsUp.TIMER, null).orElse(null);
            current.timers = original.timers;
            current.global = original.global;
            if (original.isBossKilled()) {
                current.bossKilled();
            }
        }
    }

    @SubscribeEvent
    public static void SpawnSet(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayerEntity player;
        Timer timer;
        TimerCapability cap;
        if (Configs.safeRespawn && (cap = (TimerCapability)event.getPlayer().getCapability(TimeIsUp.TIMER).orElse(null)) != null && (timer = cap.timers.get((player = (ServerPlayerEntity)event.getPlayer()).func_71121_q().func_234923_W_())) != null && timer.getDuration() < 20) {
            ServerWorld world = player.func_184102_h().func_241755_D_();
            BlockPos spawn = world.func_241135_u_();
            player.func_200619_a(world, (double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p(), player.field_70125_A, player.field_70177_z);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        TimerCapability cap;
        if (event.phase == TickEvent.Phase.END && (cap = (TimerCapability)event.player.getCapability(TimeIsUp.TIMER, null).orElse(null)) != null && !event.player.func_184812_l_()) {
            cap.Tick((RegistryKey<World>)event.player.func_130014_f_().func_234923_W_(), (LivingEntity)event.player);
        }
    }

    @SubscribeEvent
    public static void onLivingKilled(LivingDeathEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (source instanceof ServerPlayerEntity) {
            if (!Configs.blacklist.contains(source.field_70170_p.func_234923_W_()) && ((ServerPlayerEntity)source).func_70681_au().nextFloat() < Configs.exileChance) {
                ((ServerPlayerEntity)source).func_195064_c(new EffectInstance((Effect)ItemRegistry.exileEffect, 60, Configs.exileStrength, true, true));
            }
            if (Configs.boss != null) {
                CompoundNBT entityNbt = event.getEntityLiving().serializeNBT();
                for (String key : Configs.boss.func_150296_c()) {
                    if (entityNbt.func_74764_b(key) && Configs.boss.func_74781_a(key).equals(entityNbt.func_74781_a(key))) continue;
                    return;
                }
                TimerCapability cap = (TimerCapability)source.getCapability(TimeIsUp.TIMER, null).orElse(null);
                if (cap != null && !cap.isBossKilled()) {
                    source.func_145747_a((ITextComponent)new StringTextComponent(Configs.bossMessage), Util.field_240973_b_);
                    cap.bossKilled();
                    cap.ward = 0;
                    PacketHandler.INSTANCE.sendTo((Object)new TimerPacket(-1), ((ServerPlayerEntity)source).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        TimerCapability cap;
        if (event.getEntity() instanceof ServerPlayerEntity && (cap = (TimerCapability)event.getEntity().getCapability(TimeIsUp.TIMER, null).orElse(null)) != null) {
            Timer timer = cap.getOrCreate((RegistryKey<World>)event.getWorld().func_234923_W_(), (PlayerEntity)event.getEntity());
            int duration = -1;
            if (timer != null) {
                duration = timer.getDuration();
                PacketHandler.INSTANCE.sendTo((Object)new RecoverRatePacket(timer.getMaxDuration(), timer.getRecoverAmount(), timer.getRecoverCooldown()), ((ServerPlayerEntity)event.getEntity()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
            PacketHandler.INSTANCE.sendTo((Object)new TimerPacket(duration), ((ServerPlayerEntity)event.getEntity()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

