/*
 * Decompiled with CFR 0.152.
 */
package timeisup.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import timeisup.Configs;
import timeisup.ItemRegistry;

@Mod.EventBusSubscriber(modid="timeisup", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimingEventClient {
    private static final ResourceLocation CLOCK = new ResourceLocation("timeisup", "textures/gui/clock.png");
    private static final ResourceLocation VIGNETTE_TEX_PATH = new ResourceLocation("timeisup", "textures/misc/vignette.png");
    private static final ResourceLocation WARD_VIGNETTE_TEX_PATH = new ResourceLocation("timeisup", "textures/misc/ward_vignette.png");
    private static final ResourceLocation END_WARD_VIGNETTE_TEX_PATH = new ResourceLocation("timeisup", "textures/misc/end_ward_vignette.png");
    public static int ticksDuration = -1;
    public static int ward = 0;
    public static boolean warded = false;
    public static int recovered = 0;
    public static int cooldown = 0;
    public static int maxDuration = 0;
    private static int ticksRecover = 0;

    @SubscribeEvent
    public static void onPlayerJoin(EntityLeaveWorldEvent event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            warded = false;
        }
    }

    @SubscribeEvent
    public static void TimerDraw(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && ticksDuration > -1) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            String timer = StringUtils.func_76337_a((int)ticksDuration);
            MainWindow window = event.getWindow();
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            if (ward > 0) {
                if (ward >= 35) {
                    TimingEventClient.drawVignette(event.getMatrixStack(), window, mc, 0xDDAA22, (float)(70 - ward) / 35.0f, warded ? WARD_VIGNETTE_TEX_PATH : END_WARD_VIGNETTE_TEX_PATH);
                } else {
                    TimingEventClient.drawVignette(event.getMatrixStack(), window, mc, 0xDDAA22, (float)ward / 35.0f, warded ? WARD_VIGNETTE_TEX_PATH : END_WARD_VIGNETTE_TEX_PATH);
                }
            }
            if (ticksDuration >= Configs.dangerous) {
                MatrixStack matrixStack = event.getMatrixStack();
                int n = window.func_198087_p();
                font.getClass();
                TimingEventClient.drawClock(matrixStack, 5, n - (9 + 5), 0.3f, mc);
                MatrixStack matrixStack2 = event.getMatrixStack();
                int n2 = window.func_198087_p();
                font.getClass();
                font.func_238421_b_(matrixStack2, timer, 18.0f, (float)(n2 - (9 + 4)), (warded ? TextFormatting.GOLD.func_211163_e() : TextFormatting.DARK_GREEN.func_211163_e()).intValue());
            } else {
                TimingEventClient.drawVignette(event.getMatrixStack(), window, mc, mc.field_71441_e.func_226691_t_(mc.field_71439_g.func_233580_cy_()).func_235080_i_(), (float)(Configs.dangerous - ticksDuration) / (float)Configs.dangerous, VIGNETTE_TEX_PATH);
                if (ticksDuration >= Configs.emergency) {
                    MatrixStack matrixStack = event.getMatrixStack();
                    int n = window.func_198087_p();
                    font.getClass();
                    TimingEventClient.drawClock(matrixStack, 5, n - (9 + 5), 0.3f, mc);
                    MatrixStack matrixStack3 = event.getMatrixStack();
                    int n3 = window.func_198087_p();
                    font.getClass();
                    font.func_238421_b_(matrixStack3, timer, 18.0f, (float)(n3 - (9 + 4)), (warded ? TextFormatting.GOLD.func_211163_e() : TextFormatting.RED.func_211163_e()).intValue());
                } else if (ticksDuration > 0) {
                    RenderSystem.scalef((float)4.0f, (float)4.0f, (float)1.0f);
                    MatrixStack matrixStack = event.getMatrixStack();
                    int n = window.func_198107_o() / 8 - (font.func_78256_a(timer) - 1) / 2 - 6;
                    int n4 = window.func_198087_p() / 14;
                    font.getClass();
                    TimingEventClient.drawClock(matrixStack, n, n4 - 9 / 2, 0.3f, mc);
                    MatrixStack matrixStack4 = event.getMatrixStack();
                    String string = StringUtils.func_76337_a((int)ticksDuration);
                    float f = window.func_198107_o() / 8 - (font.func_78256_a(timer) - 1) / 2 + 6;
                    int n5 = window.func_198087_p() / 14;
                    font.getClass();
                    font.func_238405_a_(matrixStack4, string, f, (float)(n5 - 9 / 2 + 1), (warded ? TextFormatting.GOLD.func_211163_e() : TextFormatting.DARK_RED.func_211163_e()).intValue());
                }
            }
            RenderSystem.popMatrix();
        }
    }

    private static void drawClock(MatrixStack mstack, int left, int top, float scale, Minecraft mc) {
        mc.func_110434_K().func_110577_a(CLOCK);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        AbstractGui.func_238464_a_((MatrixStack)mstack, (int)((int)((float)left / scale)), (int)((int)((float)top / scale)), (int)0, (float)32.0f, (float)32.0f, (int)32, (int)32, (int)32, (int)32);
        RenderSystem.popMatrix();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (event.player == player) {
                if (!player.func_184812_l_()) {
                    if (warded) {
                        if (ticksDuration < maxDuration && ++ticksRecover >= cooldown) {
                            ticksRecover = 0;
                            ticksDuration += recovered;
                        }
                    } else if (ticksDuration > 0) {
                        EffectInstance exileInstance;
                        if (Configs.warnings.stream().anyMatch(tick -> tick == ticksDuration) || ticksDuration <= Configs.emergency && ticksDuration % 20 == 0) {
                            mc.func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 1.1f, 0.5f, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
                        }
                        if ((exileInstance = player.func_70660_b((Effect)ItemRegistry.exileEffect)) != null) {
                            ticksDuration -= exileInstance.func_76458_c() + 1;
                        }
                        --ticksDuration;
                    }
                }
                if (ward > 0) {
                    if (ward == 65) {
                        mc.func_147118_V().func_147682_a((ISound)new SimpleSound(warded ? SoundEvents.field_187548_af : SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 0.8f, 1.0f, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
                    }
                    --ward;
                }
            }
        }
    }

    private static void drawVignette(MatrixStack mstack, MainWindow window, Minecraft mc, int color, float alpha, ResourceLocation picture) {
        mc.func_110434_K().func_110577_a(picture);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        TimingEventClient.innerBlit(mstack.func_227866_c_().func_227870_a_(), 0, window.func_198107_o(), 0, window.func_198087_p(), -90, 0.0f, 1.0f, 0.0f, 1.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, alpha);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float r, float g, float b, float alpha) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)(alpha * 1.25f));
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)blitOffset).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)blitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)blitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)blitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

