/*
 * Decompiled with CFR 0.152.
 */
package timeisup.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import timeisup.TimeIsUp;
import timeisup.capabilities.Timer;
import timeisup.capabilities.TimerCapability;
import timeisup.events.TimingEventClient;
import timeisup.network.PacketHandler;
import timeisup.network.TimerPacket;

public class TimerAnchor
extends Item {
    public TimerAnchor() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200915_b(11));
        this.setRegistryName("timeisup", "timer_anchor");
    }

    private int getDuration(CompoundNBT nbt, World worldIn, PlayerEntity playerIn, int current_duration) {
        if (nbt.func_74764_b("anchor_player") && playerIn.func_110124_au().equals(nbt.func_186857_a("anchor_player")) && nbt.func_150297_b("anchor", 99) && nbt.func_150297_b("anchor_dim", 8)) {
            String dim_id = nbt.func_74779_i("anchor_dim");
            if (worldIn.func_234923_W_().func_240901_a_().toString().equals(dim_id)) {
                int time = nbt.func_74762_e("anchor");
                return time - current_duration;
            }
        }
        return 0;
    }

    private ListNBT newDoubleNBTList(double ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        Timer player_timer;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        TimerCapability cap = (TimerCapability)playerIn.getCapability(TimeIsUp.TIMER, null).orElse(null);
        if (cap != null && (player_timer = cap.getOrCreate((RegistryKey<World>)worldIn.func_234923_W_(), playerIn)) != null) {
            int substract_duration;
            CompoundNBT nbt = itemstack.func_196082_o();
            if (itemstack.func_77952_i() < itemstack.func_77958_k() - 1 && (substract_duration = this.getDuration(nbt, worldIn, playerIn, player_timer.getDuration())) > 0 && nbt.func_150297_b("anchor_pos", 9)) {
                ListNBT listnbt = nbt.func_150295_c("anchor_pos", 6);
                playerIn.func_242281_f(listnbt.func_150309_d(0), listnbt.func_150309_d(1), listnbt.func_150309_d(2));
                player_timer.addDuration(substract_duration / 2);
                PacketHandler.INSTANCE.sendTo((Object)new TimerPacket(player_timer.getDuration()), ((ServerPlayerEntity)playerIn).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                playerIn.func_184811_cZ().func_185145_a((Item)this, substract_duration * 2);
                itemstack.func_222118_a(1, (LivingEntity)playerIn, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            } else if (playerIn.func_213453_ef()) {
                nbt.func_186854_a("anchor_player", playerIn.func_110124_au());
                nbt.func_74768_a("anchor", player_timer.getDuration());
                nbt.func_74778_a("anchor_dim", worldIn.func_234923_W_().func_240901_a_().toString());
                nbt.func_218657_a("anchor_pos", (INBT)this.newDoubleNBTList(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_()));
            }
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "Refill with " + Items.field_151079_bi.func_200296_o().getString()));
        } else if (stack.func_77942_o() && worldIn != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int duration = this.getDuration(stack.func_77978_p(), worldIn, (PlayerEntity)mc.field_71439_g, TimingEventClient.ticksDuration);
            if (duration != 0) {
                if (duration < 0) {
                    duration = 0;
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Shift + right click to set to current timer"));
                }
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Right click to recover " + StringUtils.func_76337_a((int)(duration / 2))));
                if (stack.func_77978_p().func_150297_b("anchor_pos", 9)) {
                    ListNBT listnbt = stack.func_77978_p().func_150295_c("anchor_pos", 6);
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "and be teleported to" + TextFormatting.YELLOW + " " + (int)listnbt.func_150309_d(0) + " " + (int)listnbt.func_150309_d(1) + " " + (int)listnbt.func_150309_d(2)));
                }
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Cooldown : " + StringUtils.func_76337_a((int)(duration * 2))));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Shift + right click to set to current timer"));
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(stack.func_77952_i() + 1) / (double)stack.func_77958_k();
    }
}

