/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import dev.gigaherz.toolbelt.ConfigData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolBeltInventory
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    ToolBeltInventory(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    private CompoundTag getTag() {
        CompoundTag tag = this.itemStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            this.itemStack.m_41751_(tag);
        }
        return tag;
    }

    public int getSlots() {
        return Mth.m_14045_((int)this.getTag().m_128451_("Size"), (int)2, (int)9);
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ListTag tagList = this.getTag().m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            if (itemTags.m_128451_("Slot") != slot) continue;
            return ItemStack.m_41712_((CompoundTag)itemTags);
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        boolean hasStack;
        this.validateSlotIndex(slot);
        CompoundTag itemTag = null;
        boolean bl = hasStack = stack.m_41613_() > 0;
        if (hasStack) {
            itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", slot);
            stack.m_41739_(itemTag);
        }
        ListTag tagList = this.getTag().m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag existing = tagList.m_128728_(i);
            if (existing.m_128451_("Slot") != slot) continue;
            if (hasStack) {
                tagList.set(i, (Tag)itemTag);
            } else {
                tagList.remove(i);
            }
            return;
        }
        if (hasStack) {
            tagList.add((Object)itemTag);
        }
        this.getTag().m_128365_("Items", (Tag)tagList);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        if (stack.m_41613_() <= 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.m_41741_();
        if (existing.m_41613_() > 0) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41613_() <= 0) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    protected boolean canInsertItem(int slot, ItemStack stack) {
        return ConfigData.isItemStackAllowed(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41613_() <= 0) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.f_41583_);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

