/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.RadialMenuScreen;
import dev.gigaherz.toolbelt.client.ToolBeltLayer;
import dev.gigaherz.toolbelt.common.BeltSlotContainer;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HuskRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import net.minecraftforge.fmlclient.registry.RenderingRegistry;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="toolbelt", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    public static KeyMapping OPEN_TOOL_MENU_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_LEFT_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_RIGHT_KEYBIND;
    public static KeyMapping OPEN_BELT_SLOT_KEYBIND;
    private static boolean toolMenuKeyWasDown;
    public static ModelLayerLocation BELT_LAYER;

    public static void wipeOpen() {
        Minecraft.m_91087_().f_91068_.m_90926_(false);
        while (OPEN_TOOL_MENU_KEYBIND.m_90859_()) {
        }
    }

    public static void initKeybinds() {
        OPEN_TOOL_MENU_KEYBIND = new KeyMapping("key.toolbelt.open", 82, "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_TOOL_MENU_KEYBIND);
        CYCLE_TOOL_MENU_LEFT_KEYBIND = new KeyMapping("key.toolbelt.cycle.left", InputConstants.f_84822_.m_84873_(), "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)CYCLE_TOOL_MENU_LEFT_KEYBIND);
        CYCLE_TOOL_MENU_RIGHT_KEYBIND = new KeyMapping("key.toolbelt.cycle.right", InputConstants.f_84822_.m_84873_(), "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)CYCLE_TOOL_MENU_RIGHT_KEYBIND);
        OPEN_BELT_SLOT_KEYBIND = new KeyMapping("key.toolbelt.slot", 86, "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_BELT_SLOT_KEYBIND);
    }

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            boolean toolMenuKeyIsDown = OPEN_TOOL_MENU_KEYBIND.m_90857_();
            if (toolMenuKeyIsDown && !toolMenuKeyWasDown) {
                while (OPEN_TOOL_MENU_KEYBIND.m_90859_()) {
                    ItemStack inHand;
                    if (mc.f_91080_ != null || !ConfigData.isItemStackAllowed(inHand = mc.f_91074_.m_21205_())) continue;
                    BeltFinder.findBelt((LivingEntity)mc.f_91074_).ifPresent(getter -> mc.m_91152_((Screen)new RadialMenuScreen((BeltFinder.BeltGetter)getter)));
                }
            }
            toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            toolMenuKeyWasDown = true;
        }
        if (ConfigData.customBeltSlotEnabled) {
            while (OPEN_BELT_SLOT_KEYBIND.m_90859_()) {
                if (mc.f_91080_ != null) continue;
                ToolBelt.channel.sendToServer((Object)new OpenBeltSlotInventory());
            }
        }
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        if (keybind.m_90862_()) {
            return false;
        }
        boolean isDown = false;
        switch (keybind.getKey().m_84868_()) {
            case KEYSYM: {
                isDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_());
                break;
            }
            case MOUSE: {
                isDown = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_()) == 1;
            }
        }
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    static {
        GuiContainerEvent.class.getName();
        GuiContainerEvent.DrawBackground.class.getName();
        toolMenuKeyWasDown = false;
        BELT_LAYER = new ModelLayerLocation(new ResourceLocation("minecraft:player"), "toolbelt_belt");
    }

    @Mod.EventBusSubscriber(modid="toolbelt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            RenderingRegistry.registerLayerDefinition((ModelLayerLocation)BELT_LAYER, ToolBeltLayer.BeltModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre event) {
            if (event.getMap().m_118330_() == TextureAtlas.f_118259_) {
                event.addSprite(BeltSlotContainer.SLOT_BACKGROUND);
            }
        }

        @SubscribeEvent
        public static void construct(ParticleFactoryRegisterEvent event) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)new ResourceManagerReloadListener(){

                public void m_6213_(ResourceManager p_10758_) {
                    ModBusEvents.addLayerToEntity(EntityType.f_20529_, ArmorStandRenderer.class);
                    ModBusEvents.addLayerToEntity(EntityType.f_20501_, ZombieRenderer.class);
                    ModBusEvents.addLayerToEntity(EntityType.f_20524_, SkeletonRenderer.class);
                    ModBusEvents.addLayerToEntity(EntityType.f_20458_, HuskRenderer.class);
                    ModBusEvents.addLayerToEntity(EntityType.f_20562_, DrownedRenderer.class);
                    ModBusEvents.addLayerToEntity(EntityType.f_20481_, StrayRenderer.class);
                    Map skinMap = Minecraft.m_91087_().m_91290_().getSkinMap();
                    ModBusEvents.addLayerToPlayerSkin(skinMap, "default");
                    ModBusEvents.addLayerToPlayerSkin(skinMap, "slim");
                }
            });
        }

        private static void addLayerToPlayerSkin(Map<String, EntityRenderer<? extends Player>> skinMap, String skinName) {
            EntityRenderer<? extends Player> render = skinMap.get(skinName);
            if (render instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)render;
                livingRenderer.m_115326_(new ToolBeltLayer(livingRenderer));
            }
        }

        private static <T extends LivingEntity, M extends HumanoidModel<T>, R extends LivingEntityRenderer<? super T, M>> void addLayerToEntity(EntityType<? extends T> entityType, Class<R> rendererClass) {
            EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(entityType);
            if (!rendererClass.isInstance(renderer)) {
                throw new IllegalStateException("Mismatched renderer class?!");
            }
            if (!(((LivingEntityRenderer)renderer).m_7200_() instanceof HumanoidModel)) {
                throw new IllegalStateException("Wrong model type, renderer for entity " + entityType.getRegistryName() + " needs to use a BipedModel.");
            }
            LivingEntityRenderer bipedRenderer = (LivingEntityRenderer)renderer;
            bipedRenderer.m_115326_(new ToolBeltLayer(bipedRenderer));
        }
    }
}

