/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.ClientEvents;
import dev.gigaherz.toolbelt.client.radial.GenericRadialMenu;
import dev.gigaherz.toolbelt.client.radial.IRadialMenuHost;
import dev.gigaherz.toolbelt.client.radial.ItemStackRadialMenuItem;
import dev.gigaherz.toolbelt.client.radial.RadialMenuItem;
import dev.gigaherz.toolbelt.client.radial.TextRadialMenuItem;
import dev.gigaherz.toolbelt.network.SwapItems;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RadialMenuScreen
extends Screen {
    private final BeltFinder.BeltGetter getter;
    private ItemStack stackEquipped;
    private IItemHandler inventory;
    private boolean keyCycleBeforeL = false;
    private boolean keyCycleBeforeR = false;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final TextRadialMenuItem insertMenuItem;
    private final GenericRadialMenu menu;

    private ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    public RadialMenuScreen(BeltFinder.BeltGetter getter) {
        super((Component)new TextComponent("RADIAL MENU"));
        this.getter = getter;
        this.stackEquipped = getter.getBelt();
        this.inventory = this.stackEquipped.m_41613_() > 0 ? (IItemHandler)this.stackEquipped.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(null) : null;
        this.menu = new GenericRadialMenu(Minecraft.m_91087_(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(PoseStack matrixStack, ItemStack stack, int mouseX, int mouseY) {
                RadialMenuScreen.this.m_6057_(matrixStack, stack, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return RadialMenuScreen.this;
            }

            @Override
            public Font getFontRenderer() {
                return RadialMenuScreen.this.f_96547_;
            }

            @Override
            public ItemRenderer getItemRenderer() {
                return RadialMenuScreen.this.getItemRenderer();
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.insertMenuItem = new TextRadialMenuItem(this.menu, (Component)new TranslatableComponent("text.toolbelt.insert")){

            @Override
            public boolean onClick() {
                return RadialMenuScreen.this.trySwap(-1, ItemStack.f_41583_);
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay() != ForgeIngameGui.CROSSHAIR_ELEMENT) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof RadialMenuScreen) {
            event.setCanceled(true);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ClientEvents.wipeOpen();
    }

    public void m_96624_() {
        super.m_96624_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.m_91087_().m_91152_(null);
            ClientEvents.wipeOpen();
        }
        if (!this.menu.isReady() || this.inventory == null) {
            return;
        }
        ItemStack inHand = this.f_96541_.f_91074_.m_21205_();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            this.inventory = null;
        } else {
            ItemStack stack = this.getter.getBelt();
            if (stack.m_41613_() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(() -> new RuntimeException("No inventory?"));
                this.needsRecheckStacks = true;
            }
        }
        if (this.inventory == null) {
            Minecraft.m_91087_().m_91152_(null);
        } else if (!ClientEvents.isKeyDown(ClientEvents.OPEN_TOOL_MENU_KEYBIND)) {
            if (ConfigData.releaseToSwap) {
                this.processClick(false);
            } else {
                this.menu.close();
            }
        }
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
        if (this.inventory == null) {
            return;
        }
        ItemStack inHand = this.f_96541_.f_91074_.m_21205_();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack inSlot = this.inventory.getStackInSlot(i);
                ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (Component)new TranslatableComponent("text.toolbelt.empty")){

                    @Override
                    public boolean onClick() {
                        return RadialMenuScreen.this.trySwap(this.getSlot(), this.getStack());
                    }
                };
                item.setVisible(inSlot.m_41613_() > 0 || ConfigData.displayEmptySlots);
                if (inHand.m_41613_() > 0) {
                    if (inSlot.m_41613_() > 0) {
                        item.setCentralText((Component)new TranslatableComponent("text.toolbelt.swap"));
                    } else {
                        item.setCentralText((Component)new TranslatableComponent("text.toolbelt.insert"));
                    }
                } else if (inSlot.m_41613_() > 0) {
                    item.setCentralText((Component)new TranslatableComponent("text.toolbelt.extract"));
                } else {
                    item.setCentralText((Component)new TranslatableComponent("text.toolbelt.empty"));
                }
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.menu.add(this.insertMenuItem);
            this.needsRecheckStacks = false;
        }
        boolean hasAddButton = false;
        if (!ConfigData.displayEmptySlots && !this.cachedMenuItems.stream().allMatch(RadialMenuItem::isVisible) && inHand.m_41613_() > 0) {
            hasAddButton = true;
        }
        this.insertMenuItem.setVisible(hasAddButton);
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((Component)new TranslatableComponent("text.toolbelt.empty"));
        } else {
            this.menu.setCentralText(null);
        }
        this.checkCycleKeybinds();
        this.menu.draw(matrixStack, partialTicks, mouseX, mouseY);
    }

    private boolean trySwap(int slotNumber, ItemStack itemMouseOver) {
        ItemStack inHand = this.f_96541_.f_91074_.m_21205_();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            return false;
        }
        if (inHand.m_41613_() > 0 || itemMouseOver.m_41613_() > 0) {
            SwapItems.swapItem(slotNumber, (Player)this.f_96541_.f_91074_);
            ToolBelt.channel.sendToServer((Object)new SwapItems(slotNumber));
        }
        this.menu.close();
        return true;
    }

    private void checkCycleKeybinds() {
        if (ClientEvents.isKeyDown(ClientEvents.CYCLE_TOOL_MENU_LEFT_KEYBIND)) {
            if (!this.keyCycleBeforeL) {
                this.menu.cyclePrevious();
            }
            this.keyCycleBeforeL = true;
        } else {
            this.keyCycleBeforeL = false;
        }
        if (ClientEvents.isKeyDown(ClientEvents.CYCLE_TOOL_MENU_RIGHT_KEYBIND)) {
            if (!this.keyCycleBeforeR) {
                this.menu.cycleNext();
            }
            this.keyCycleBeforeR = true;
        } else {
            this.keyCycleBeforeR = false;
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

