/*
 * Decompiled with CFR 0.152.
 */
package net.thegrimsey.transportables.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.thegrimsey.transportables.TransportablesItems;
import net.thegrimsey.transportables.entity.CarriageEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCarriageEntity
extends class_1309 {
    static final class_2940<Optional<UUID>> CARRIAGE_HOLDER = class_2945.method_12791(CarriageEntity.class, (class_2941)class_2943.field_13313);
    public static final class_4048 CARRIAGE_DIMENSIONS = class_4048.method_18385((float)2.5f, (float)1.5f);
    final float FOLLOW_DISTANCE = 2.75f;
    final int MAX_PASSENGERS = 4;
    final float SEATING_Y_OFFSET = 0.1f;
    final String CARRIAGE_HOLDER_KEY = "carriageHolder";
    @Nullable
    class_1496 carriageHolder = null;

    protected AbstractCarriageEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
        Objects.requireNonNull(this.method_5996(class_5134.field_23718)).method_6192(0.95);
    }

    public boolean HasCarriageHolder() {
        return ((Optional)this.field_6011.method_12789(CARRIAGE_HOLDER)).isPresent();
    }

    public void setCarriageHolder(class_1496 carriageHolder) {
        this.field_6011.method_12778(CARRIAGE_HOLDER, Optional.of(carriageHolder.method_5667()));
        this.carriageHolder = carriageHolder;
    }

    public void removeCarriageHolder() {
        this.field_6011.method_12778(CARRIAGE_HOLDER, Optional.empty());
        this.carriageHolder = null;
    }

    public void method_5773() {
        class_1297 playerVehicle;
        class_1297 carriageHolder;
        Optional holderId;
        super.method_5773();
        if (this.carriageHolder != null) {
            if (!this.carriageHolder.method_5805()) {
                this.removeCarriageHolder();
            }
        } else if (!this.field_6002.field_9236 && (holderId = (Optional)this.field_6011.method_12789(CARRIAGE_HOLDER)).isPresent() && (carriageHolder = ((class_3218)this.field_6002).method_14190((UUID)holderId.get())) instanceof class_1498) {
            this.setCarriageHolder((class_1496)((class_1498)carriageHolder));
        }
        if (this.field_6002.field_9236 && (holderId = (Optional)this.field_6011.method_12789(CARRIAGE_HOLDER)).isPresent() && (playerVehicle = class_310.method_1551().field_1724.method_5854()) != null && playerVehicle.method_5667().equals(holderId.get())) {
            this.carriageHolder = (class_1496)playerVehicle;
            this.tickCarriageMovement();
        }
        this.field_6283 = this.field_6031;
    }

    protected void method_6023() {
        this.tickCarriageMovement();
    }

    protected void tickCarriageMovement() {
        boolean shouldMove;
        if (this.carriageHolder == null) {
            return;
        }
        class_243 delta = this.method_19538().method_1020(this.carriageHolder.method_19538());
        boolean bl = shouldMove = delta.method_1027() > 7.5625;
        if (shouldMove) {
            double distanceToMove = delta.method_1033() - 2.75;
            this.method_5784(class_1313.field_6308, delta.method_1029().method_1021(distanceToMove * -1.0));
        }
        double yaw = Math.toDegrees(Math.atan2(delta.field_1350, delta.field_1352)) + 90.0;
        this.method_5710((float)yaw, 0.0f);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.field_6002.method_8608()) {
            return player.method_5804((class_1297)this) ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void method_5865(class_1297 passenger) {
        if (this.method_5626(passenger)) {
            int i = this.method_5685().indexOf(passenger);
            double x = 0.5f - (float)(i >> 1) * 1.2f;
            double z = -0.7f + (float)(i % 2) * 1.3f;
            float angle = -this.field_6031 * ((float)Math.PI / 180) - 1.5707964f;
            double f = class_3532.method_15362((float)angle);
            double g = class_3532.method_15374((float)angle);
            double rX = x * f + z * g;
            double rZ = z * f - x * g;
            passenger.method_5814(this.method_23317() + rX, this.method_23318() + (double)0.1f, this.method_23321() + rZ);
            this.updatePassengerRotation(passenger);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5644(class_1297 entity) {
        this.updatePassengerRotation(entity);
    }

    protected void updatePassengerRotation(class_1297 entity) {
        float rot = 90.0f * (this.method_5685().indexOf(entity) % 2 == 0 ? -1.0f : 1.0f);
        entity.method_5636(this.field_6031 + rot);
        float f = class_3532.method_15393((float)(entity.field_6031 - this.field_6031 + rot));
        float g = class_3532.method_15363((float)f, (float)-89.9f, (float)89.9f);
        entity.field_5982 += g - f;
        entity.field_6031 += g - f;
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 4;
    }

    public boolean method_5817() {
        return false;
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("carriageHolder")) {
            this.field_6011.method_12778(CARRIAGE_HOLDER, Optional.of(tag.method_25926("carriageHolder")));
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.carriageHolder != null) {
            tag.method_25927("carriageHolder", this.carriageHolder.method_5667());
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CARRIAGE_HOLDER, Optional.empty());
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10211();
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    public class_1306 method_6068() {
        return class_1306.field_6182;
    }

    protected void method_16080(class_1282 source) {
        if (this.field_6002.method_8450().method_8355(class_1928.field_19391)) {
            class_1799 drops = new class_1799((class_1935)TransportablesItems.CARRIAGE_ITEM);
            if (this.method_16914()) {
                drops.method_7977(this.method_5797());
            }
            this.method_5775(drops);
        }
    }
}

