/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketInventoryRenderer;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketSlots;
import dev.emi.trinkets.mixin.SlotMixin;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_4493;
import net.minecraft.class_481;
import net.minecraft.class_485;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_481.class})
public abstract class CreativeInventoryScreenMixin
extends class_485<class_481.class_483> {
    @Shadow
    private static int field_2896;
    private List<class_1735> creativeSlots = new ArrayList<class_1735>();
    private int mouseX;
    private int mouseY;

    public CreativeInventoryScreenMixin(class_481.class_483 container, class_1661 inventory, class_2561 text) {
        super((class_1703)container, inventory, text);
    }

    @Inject(at={@At(value="TAIL")}, method={"init"})
    public void init(CallbackInfo info) {
        if (this.creativeSlots.size() == 0) {
            return;
        }
        TrinketsClient.displayEquipped = 0;
        List<TrinketSlots.Slot> trinketSlots = TrinketSlots.getAllSlots();
        for (int i = 0; i < trinketSlots.size(); ++i) {
            if (!trinketSlots.get((int)i).getSlotGroup().onReal && trinketSlots.get((int)i).getSlotGroup().slots.get(0).equals(trinketSlots.get(i))) {
                ((SlotMixin)this.creativeSlots.get(i)).setXPosition(this.getGroupX(trinketSlots.get(i).getSlotGroup()) + 1);
                ((SlotMixin)this.creativeSlots.get(i)).setYPosition(this.getGroupY(trinketSlots.get(i).getSlotGroup()) + 1);
                continue;
            }
            ((SlotMixin)this.creativeSlots.get(i)).setXPosition(Integer.MIN_VALUE);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    protected void tick(CallbackInfo info) {
        if (field_2896 != class_1761.field_7918.method_7741()) {
            return;
        }
        List<TrinketSlots.Slot> trinketSlots = TrinketSlots.getAllSlots();
        float relX = this.mouseX - this.field_2776;
        float relY = this.mouseY - this.field_2800;
        if (TrinketsClient.slotGroup == null || !this.inBounds(TrinketsClient.slotGroup, relX, relY, true)) {
            if (TrinketsClient.slotGroup != null) {
                for (int i = 0; i < trinketSlots.size(); ++i) {
                    if (!trinketSlots.get(i).getSlotGroup().getName().equals(TrinketsClient.slotGroup.getName()) || !TrinketsClient.slotGroup.onReal && TrinketsClient.slotGroup.slots.get(0) == trinketSlots.get(i)) continue;
                    ((SlotMixin)this.creativeSlots.get(i)).setXPosition(Integer.MIN_VALUE);
                }
            }
            TrinketsClient.slotGroup = null;
            for (TrinketSlots.SlotGroup group : TrinketSlots.slotGroups) {
                int i;
                if (!this.inBounds(group, relX, relY, false) || group.slots.size() <= 0) continue;
                TrinketsClient.displayEquipped = 0;
                TrinketsClient.slotGroup = group;
                ArrayList<class_1735> tSlots = new ArrayList<class_1735>();
                for (int i2 = 0; i2 < trinketSlots.size(); ++i2) {
                    if (trinketSlots.get(i2).getSlotGroup() != group) continue;
                    tSlots.add(this.creativeSlots.get(i2));
                }
                if (tSlots.size() == 0) {
                    return;
                }
                int groupX = this.getGroupX(group);
                int groupY = this.getGroupY(group);
                int count = group.slots.size();
                int offset = 1;
                if (group.onReal) {
                    ++count;
                    offset = 0;
                } else {
                    ((SlotMixin)tSlots.get(0)).setXPosition(groupX + 1);
                    ((SlotMixin)tSlots.get(0)).setYPosition(groupY + 1);
                }
                int l = count / 2;
                int r = count - l - 1;
                for (i = 0; i < l; ++i) {
                    ((SlotMixin)tSlots.get(i + offset)).setXPosition(groupX - (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + offset)).setYPosition(groupY + 1);
                }
                for (i = 0; i < r; ++i) {
                    ((SlotMixin)tSlots.get(i + l + offset)).setXPosition(groupX + (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + l + offset)).setYPosition(groupY + 1);
                }
                TrinketsClient.activeSlots = new ArrayList<class_1735>();
                if (group.vanillaSlot != -1) {
                    TrinketsClient.activeSlots.add(((class_481.class_483)this.field_2797).method_7611(group.vanillaSlot));
                }
                for (class_1735 ts : tSlots) {
                    TrinketsClient.activeSlots.add(ts);
                }
            }
        }
        if (TrinketsClient.displayEquipped > 0) {
            TrinketSlots.SlotGroup group;
            --TrinketsClient.displayEquipped;
            if (TrinketsClient.slotGroup == null && (group = TrinketsClient.lastEquipped) != null) {
                int i;
                ArrayList<class_1735> tSlots = new ArrayList<class_1735>();
                for (int i3 = 0; i3 < trinketSlots.size(); ++i3) {
                    if (!trinketSlots.get(i3).getSlotGroup().getName().equals(group.getName())) continue;
                    tSlots.add(this.creativeSlots.get(i3));
                }
                if (tSlots.size() == 0) {
                    return;
                }
                int groupX = this.getGroupX(group);
                int groupY = this.getGroupY(group);
                int count = group.slots.size();
                int offset = 1;
                if (group.onReal) {
                    ++count;
                    offset = 0;
                } else {
                    ((SlotMixin)tSlots.get(0)).setXPosition(groupX + 1);
                    ((SlotMixin)tSlots.get(0)).setYPosition(groupY + 1);
                }
                int l = count / 2;
                int r = count - l - 1;
                for (i = 0; i < l; ++i) {
                    ((SlotMixin)tSlots.get(i + offset)).setXPosition(groupX - (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + offset)).setYPosition(groupY + 1);
                }
                for (i = 0; i < r; ++i) {
                    ((SlotMixin)tSlots.get(i + l + offset)).setXPosition(groupX + (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + l + offset)).setYPosition(groupY + 1);
                }
                TrinketsClient.activeSlots = new ArrayList<class_1735>();
                if (group.vanillaSlot != -1) {
                    TrinketsClient.activeSlots.add(((class_481.class_483)this.field_2797).method_7611(group.vanillaSlot));
                }
                for (class_1735 ts : tSlots) {
                    TrinketsClient.activeSlots.add(ts);
                }
            }
        }
        for (int i = 0; i < trinketSlots.size(); ++i) {
            if (TrinketsClient.lastEquipped != null && TrinketsClient.displayEquipped > 0 && trinketSlots.get(i).getSlotGroup().getName().equals(TrinketsClient.lastEquipped.getName()) || TrinketsClient.slotGroup != null && trinketSlots.get(i).getSlotGroup().equals(TrinketsClient.slotGroup) || !trinketSlots.get((int)i).getSlotGroup().onReal && trinketSlots.get((int)i).getSlotGroup().slots.get(0) == trinketSlots.get(i)) continue;
            ((SlotMixin)this.creativeSlots.get(i)).setXPosition(Integer.MIN_VALUE);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"drawBackground"})
    protected void drawBackground(float f, int x, int y, CallbackInfo info) {
        if (field_2896 != class_1761.field_7918.method_7741()) {
            return;
        }
        class_4493.method_22034();
        TrinketSlots.SlotGroup lastGroup = TrinketSlots.slotGroups.get(TrinketSlots.slotGroups.size() - 1);
        int lastX = this.getGroupX(lastGroup);
        int lastY = this.getGroupY(lastGroup);
        if (lastX < 0) {
            TrinketInventoryRenderer.renderExcessSlotGroups(this, this.minecraft.method_1531(), this.field_2776, this.field_2800, lastX, lastY);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"drawForeground"})
    protected void drawForeground(int x, int y, CallbackInfo info) {
        if (field_2896 != class_1761.field_7918.method_7741()) {
            return;
        }
        super.method_2388(x, y);
        class_4493.method_22034();
        for (TrinketSlots.SlotGroup group : TrinketSlots.slotGroups) {
            if (group.onReal || group.slots.size() <= 0) continue;
            this.minecraft.method_1531().method_22813(TrinketInventoryRenderer.MORE_SLOTS_TEX);
            this.blit(this.getGroupX(group), this.getGroupY(group), 4, 4, 18, 18);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen;drawMouseoverTooltip(II)V")}, method={"render"})
    protected void drawMouseoverTooltip(int x, int y, float f, CallbackInfo info) {
        if (field_2896 != class_1761.field_7918.method_7741()) {
            return;
        }
        if (TrinketsClient.slotGroup != null) {
            TrinketInventoryRenderer.renderGroupFront(this, this.minecraft.method_1531(), this.field_17410, this.field_2776, this.field_2800, TrinketsClient.slotGroup, this.getGroupX(TrinketsClient.slotGroup), this.getGroupY(TrinketsClient.slotGroup));
        } else if (TrinketsClient.displayEquipped > 0 && TrinketsClient.lastEquipped != null) {
            TrinketInventoryRenderer.renderGroupFront(this, this.minecraft.method_1531(), this.field_17410, this.field_2776, this.field_2800, TrinketsClient.lastEquipped, this.getGroupX(TrinketsClient.lastEquipped), this.getGroupY(TrinketsClient.lastEquipped));
        } else {
            return;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    protected void render(int x, int y, float f, CallbackInfo info) {
        if (field_2896 != class_1761.field_7918.method_7741()) {
            return;
        }
        this.mouseX = x;
        this.mouseY = y;
        class_1661 inventory = this.minecraft.field_1724.field_7514;
        class_1799 stack = inventory.method_7399();
        if (!stack.method_7960()) {
            try {
                this.drawItem(stack, x - 8, y - 8, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setSelectedTab"})
    private void setSelectedTab(class_1761 itemGroup, CallbackInfo info) {
        if (itemGroup == class_1761.field_7918) {
            this.creativeSlots.clear();
            for (int i = 46; i < ((class_481.class_483)this.field_2797).field_7761.size(); ++i) {
                if (!(((class_481.class_483)this.field_2797).method_7611((int)i).field_7871 instanceof TrinketInventory)) continue;
                this.creativeSlots.add(((class_481.class_483)this.field_2797).method_7611(i));
            }
            this.init(info);
        }
    }

    public boolean inBounds(TrinketSlots.SlotGroup group, float x, float y, boolean focused) {
        int groupX = this.getGroupX(group);
        int groupY = this.getGroupY(group);
        if (focused) {
            int count = group.slots.size();
            if (group.onReal) {
                ++count;
            }
            int l = count / 2;
            int r = count - l - 1;
            return x > (float)(groupX - l * 18 - 4) && y > (float)(groupY - 4) && x < (float)(groupX + r * 18 + 22) && y < (float)(groupY + 22);
        }
        return x > (float)groupX && y > (float)groupY && x < (float)(groupX + 18) && y < (float)(groupY + 18);
    }

    public int getGroupX(TrinketSlots.SlotGroup group) {
        if (group.vanillaSlot == 5) {
            return 53;
        }
        if (group.vanillaSlot == 6) {
            return 53;
        }
        if (group.vanillaSlot == 7) {
            return 107;
        }
        if (group.vanillaSlot == 8) {
            return 107;
        }
        if (group.vanillaSlot == 45) {
            return 34;
        }
        if (group.getName().equals("hand")) {
            return 15;
        }
        int j = 0;
        if (TrinketSlots.slotGroups.get((int)5).slots.size() == 0) {
            j = -1;
        }
        for (int i = 6; i < TrinketSlots.slotGroups.size(); ++i) {
            if (TrinketSlots.slotGroups.get(i) == group) {
                if ((j += i) == 5) {
                    return 15;
                }
                if (j == 6) {
                    return 126;
                }
                if (j == 7) {
                    return 145;
                }
                return -15 - (j - 8) / 4 * 18;
            }
            if (TrinketSlots.slotGroups.get((int)i).slots.size() != 0) continue;
            --j;
        }
        return 0;
    }

    public int getGroupY(TrinketSlots.SlotGroup group) {
        if (group.vanillaSlot == 5) {
            return 5;
        }
        if (group.vanillaSlot == 6) {
            return 32;
        }
        if (group.vanillaSlot == 7) {
            return 5;
        }
        if (group.vanillaSlot == 8) {
            return 32;
        }
        if (group.vanillaSlot == 45) {
            return 19;
        }
        if (group.getName().equals("hand")) {
            return 19;
        }
        int j = 0;
        if (TrinketSlots.slotGroups.get((int)5).slots.size() == 0) {
            j = -1;
        }
        for (int i = 6; i < TrinketSlots.slotGroups.size(); ++i) {
            if (TrinketSlots.slotGroups.get(i) == group) {
                if ((j += i) < 8) {
                    return 19;
                }
                return 7 + (j - 8) % 4 * 18;
            }
            if (TrinketSlots.slotGroups.get((int)i).slots.size() != 0) continue;
            --j;
        }
        return 0;
    }

    public void drawItem(class_1799 stack, int x, int y, String string) {
        class_4493.method_21999((float)0.0f, (float)0.0f, (float)32.0f);
        this.setBlitOffset(200);
        this.itemRenderer.field_4730 = 200.0f;
        this.itemRenderer.method_4023(stack, x, y);
        this.itemRenderer.method_4022(this.font, stack, x, y, string);
        this.setBlitOffset(0);
        this.itemRenderer.field_4730 = 0.0f;
    }
}

