/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketInventoryRenderer;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.TrinketSlots;
import dev.emi.trinkets.mixin.SlotMixin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4493;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_490.class})
public abstract class InventoryScreenMixin
extends class_485<class_1723>
implements class_518 {
    @Shadow
    private float field_2935;
    @Shadow
    private float field_2934;
    @Shadow
    private static final class_2960 field_2933 = new class_2960("textures/gui/recipe_button.png");
    private List<TrinketSlot> invSlots;

    public InventoryScreenMixin(class_1723 container, class_1661 inventory, class_2561 text) {
        super((class_1703)container, inventory, text);
    }

    @Inject(at={@At(value="TAIL")}, method={"init"})
    public void init(CallbackInfo info) {
        TrinketsClient.displayEquipped = 0;
        this.invSlots = new ArrayList<TrinketSlot>();
        for (class_1735 slot : ((class_1723)this.field_2797).field_7761) {
            if (!(slot instanceof TrinketSlot)) continue;
            TrinketSlot ts = (TrinketSlot)slot;
            this.invSlots.add(ts);
            if (!ts.keepVisible) {
                ((SlotMixin)slot).setXPosition(Integer.MIN_VALUE);
                continue;
            }
            ((SlotMixin)((Object)ts)).setXPosition(this.getGroupX(TrinketSlots.getSlotFromName(ts.group, ts.slot).getSlotGroup()) + 1);
            ((SlotMixin)((Object)ts)).setYPosition(this.getGroupY(TrinketSlots.getSlotFromName(ts.group, ts.slot).getSlotGroup()) + 1);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    protected void tick(CallbackInfo info) {
        float relX = this.field_2935 - (float)this.field_2776;
        float relY = this.field_2934 - (float)this.field_2800;
        if (TrinketsClient.slotGroup == null || !this.inBounds(TrinketsClient.slotGroup, relX, relY, true)) {
            if (TrinketsClient.slotGroup != null) {
                for (TrinketSlot ts : this.invSlots) {
                    if (!ts.group.equals(TrinketsClient.slotGroup.getName()) || ts.keepVisible) continue;
                    ((SlotMixin)((Object)ts)).setXPosition(Integer.MIN_VALUE);
                }
            }
            TrinketsClient.slotGroup = null;
            for (TrinketSlots.SlotGroup group : TrinketSlots.slotGroups) {
                int i;
                if (!this.inBounds(group, relX, relY, false) || group.slots.size() <= 0) continue;
                TrinketsClient.displayEquipped = 0;
                TrinketsClient.slotGroup = group;
                ArrayList tSlots = new ArrayList();
                for (TrinketSlot ts : this.invSlots) {
                    if (!ts.group.equals(group.getName())) continue;
                    tSlots.add(ts);
                }
                int groupX = this.getGroupX(group);
                int groupY = this.getGroupY(group);
                int count = group.slots.size();
                int offset = 1;
                if (group.onReal) {
                    ++count;
                    offset = 0;
                } else {
                    ((SlotMixin)tSlots.get(0)).setXPosition(groupX + 1);
                    ((SlotMixin)tSlots.get(0)).setYPosition(groupY + 1);
                }
                int l = count / 2;
                int r = count - l - 1;
                if (tSlots.size() == 0) break;
                for (i = 0; i < l; ++i) {
                    ((SlotMixin)tSlots.get(i + offset)).setXPosition(groupX - (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + offset)).setYPosition(groupY + 1);
                }
                for (i = 0; i < r; ++i) {
                    ((SlotMixin)tSlots.get(i + l + offset)).setXPosition(groupX + (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + l + offset)).setYPosition(groupY + 1);
                }
                TrinketsClient.activeSlots = new ArrayList<class_1735>();
                if (group.vanillaSlot != -1) {
                    TrinketsClient.activeSlots.add(((class_1723)this.field_2797).method_7611(group.vanillaSlot));
                }
                Iterator i2 = tSlots.iterator();
                while (i2.hasNext()) {
                    TrinketSlot ts = (TrinketSlot)((Object)i2.next());
                    TrinketsClient.activeSlots.add(ts);
                }
                break block1;
            }
        }
        if (TrinketsClient.displayEquipped > 0) {
            TrinketSlots.SlotGroup group;
            --TrinketsClient.displayEquipped;
            if (TrinketsClient.slotGroup == null && (group = TrinketsClient.lastEquipped) != null) {
                int i;
                ArrayList<TrinketSlot> tSlots = new ArrayList<TrinketSlot>();
                for (TrinketSlot ts : this.invSlots) {
                    if (ts.group != group.getName()) continue;
                    tSlots.add(ts);
                }
                int groupX = this.getGroupX(group);
                int groupY = this.getGroupY(group);
                int count = group.slots.size();
                int offset = 1;
                if (group.onReal) {
                    ++count;
                    offset = 0;
                } else {
                    ((SlotMixin)tSlots.get(0)).setXPosition(groupX + 1);
                    ((SlotMixin)tSlots.get(0)).setYPosition(groupY + 1);
                }
                int l = count / 2;
                int r = count - l - 1;
                for (i = 0; i < l; ++i) {
                    ((SlotMixin)tSlots.get(i + offset)).setXPosition(groupX - (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + offset)).setYPosition(groupY + 1);
                }
                for (i = 0; i < r; ++i) {
                    ((SlotMixin)tSlots.get(i + l + offset)).setXPosition(groupX + (i + 1) * 18 + 1);
                    ((SlotMixin)tSlots.get(i + l + offset)).setYPosition(groupY + 1);
                }
                TrinketsClient.activeSlots = new ArrayList<class_1735>();
                if (group.vanillaSlot != -1) {
                    TrinketsClient.activeSlots.add(((class_1723)this.field_2797).method_7611(group.vanillaSlot));
                }
                for (TrinketSlot ts : tSlots) {
                    TrinketsClient.activeSlots.add(ts);
                }
            }
        }
        for (TrinketSlot ts : this.invSlots) {
            if (TrinketsClient.lastEquipped != null && TrinketsClient.displayEquipped > 0 && ts.group == TrinketsClient.lastEquipped.getName() || TrinketsClient.slotGroup != null && ts.group == TrinketsClient.slotGroup.getName() || ts.keepVisible) continue;
            ((SlotMixin)((Object)ts)).setXPosition(Integer.MIN_VALUE);
        }
        for (TrinketSlot ts : this.invSlots) {
            int groupX = this.getGroupX(TrinketSlots.getSlotFromName(ts.group, ts.slot).getSlotGroup());
            if (!ts.keepVisible || groupX >= 0) continue;
            if (this.method_2659().method_2605()) {
                ((SlotMixin)((Object)ts)).setXPosition(Integer.MIN_VALUE);
                continue;
            }
            ((SlotMixin)((Object)ts)).setXPosition(groupX + 1);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"drawBackground"})
    protected void drawBackground(float f, int x, int y, CallbackInfo info) {
        TrinketSlots.SlotGroup lastGroup = TrinketSlots.slotGroups.get(TrinketSlots.slotGroups.size() - 1);
        int lastX = this.getGroupX(lastGroup);
        int lastY = this.getGroupY(lastGroup);
        if (!this.method_2659().method_2605() && lastX < 0) {
            TrinketInventoryRenderer.renderExcessSlotGroups(this, this.minecraft.method_1531(), this.field_2776, this.field_2800, lastX, lastY);
        }
        for (TrinketSlots.SlotGroup group : TrinketSlots.slotGroups) {
            if (group.onReal || group.slots.size() <= 0 || this.method_2659().method_2605() && this.getGroupX(group) < 0) continue;
            this.minecraft.method_1531().method_22813(TrinketInventoryRenderer.MORE_SLOTS_TEX);
            this.blit(this.field_2776 + this.getGroupX(group), this.field_2800 + this.getGroupY(group), 4, 4, 18, 18);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"drawForeground"})
    protected void drawForeground(int x, int y, CallbackInfo info) {
        super.method_2388(x, y);
        class_4493.method_22034();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/InventoryScreen;drawMouseoverTooltip(II)V")}, method={"render"})
    protected void drawMouseoverTooltip(int x, int y, float f, CallbackInfo info) {
        if (TrinketsClient.slotGroup != null) {
            TrinketInventoryRenderer.renderGroupFront(this, this.minecraft.method_1531(), this.field_17410, this.field_2776, this.field_2800, TrinketsClient.slotGroup, this.getGroupX(TrinketsClient.slotGroup), this.getGroupY(TrinketsClient.slotGroup));
        } else if (TrinketsClient.displayEquipped > 0 && TrinketsClient.lastEquipped != null) {
            TrinketInventoryRenderer.renderGroupFront(this, this.minecraft.method_1531(), this.field_17410, this.field_2776, this.field_2800, TrinketsClient.lastEquipped, this.getGroupX(TrinketsClient.lastEquipped), this.getGroupY(TrinketsClient.lastEquipped));
        } else {
            return;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    protected void render(int x, int y, float f, CallbackInfo info) {
        class_1661 inventory = this.minecraft.field_1724.field_7514;
        class_1799 stack = inventory.method_7399();
        if (!stack.method_7960()) {
            try {
                class_4493.method_22028();
                this.drawItem(stack, x - 8, y - 8, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isClickOutsideBounds"}, cancellable=true)
    protected void isClickOutsideBounds(double x, double y, int i, int j, int k, CallbackInfoReturnable<Boolean> info) {
        if (TrinketsClient.slotGroup != null && this.inBounds(TrinketsClient.slotGroup, (float)x - (float)this.field_2776, (float)y - (float)this.field_2800, true)) {
            info.setReturnValue((Object)false);
        }
    }

    public boolean inBounds(TrinketSlots.SlotGroup group, float x, float y, boolean focused) {
        if (this.method_2659().method_2605() && this.getGroupX(group) < 0) {
            return false;
        }
        int groupX = this.getGroupX(group);
        int groupY = this.getGroupY(group);
        if (focused) {
            int count = group.slots.size();
            if (group.onReal) {
                ++count;
            }
            int l = count / 2;
            int r = count - l - 1;
            return x > (float)(groupX - l * 18 - 4) && y > (float)(groupY - 4) && x < (float)(groupX + r * 18 + 22) && y < (float)(groupY + 22);
        }
        return x > (float)groupX && y > (float)groupY && x < (float)(groupX + 18) && y < (float)(groupY + 18);
    }

    public int getGroupX(TrinketSlots.SlotGroup group) {
        if (group.vanillaSlot == 5) {
            return 7;
        }
        if (group.vanillaSlot == 6) {
            return 7;
        }
        if (group.vanillaSlot == 7) {
            return 7;
        }
        if (group.vanillaSlot == 8) {
            return 7;
        }
        if (group.vanillaSlot == 45) {
            return 76;
        }
        if (group.getName().equals("hand")) {
            return 76;
        }
        int j = 0;
        if (TrinketSlots.slotGroups.get((int)5).slots.size() == 0) {
            j = -1;
        }
        for (int i = 6; i < TrinketSlots.slotGroups.size(); ++i) {
            if (TrinketSlots.slotGroups.get(i) == group) {
                if ((j += i) < 8) {
                    return 76;
                }
                return -15 - (j - 8) / 4 * 18;
            }
            if (TrinketSlots.slotGroups.get((int)i).slots.size() != 0) continue;
            --j;
        }
        return 0;
    }

    public int getGroupY(TrinketSlots.SlotGroup group) {
        if (group.vanillaSlot == 5) {
            return 7;
        }
        if (group.vanillaSlot == 6) {
            return 25;
        }
        if (group.vanillaSlot == 7) {
            return 43;
        }
        if (group.vanillaSlot == 8) {
            return 61;
        }
        if (group.vanillaSlot == 45) {
            return 61;
        }
        if (group.getName().equals("hand")) {
            return 43;
        }
        int j = 0;
        if (TrinketSlots.slotGroups.get((int)5).slots.size() == 0) {
            j = -1;
        }
        for (int i = 6; i < TrinketSlots.slotGroups.size(); ++i) {
            if (TrinketSlots.slotGroups.get(i) == group) {
                if ((j += i) == 5) {
                    return 43;
                }
                if (j == 6) {
                    return 25;
                }
                if (j == 7) {
                    return 7;
                }
                return 7 + (j - 8) % 4 * 18;
            }
            if (TrinketSlots.slotGroups.get((int)i).slots.size() != 0) continue;
            --j;
        }
        return 0;
    }

    public void drawItem(class_1799 stack, int x, int y, String string) {
        class_4493.method_21999((float)0.0f, (float)0.0f, (float)32.0f);
        this.setBlitOffset(200);
        this.itemRenderer.field_4730 = 200.0f;
        this.itemRenderer.method_4023(stack, x, y);
        this.itemRenderer.method_4022(this.font, stack, x, y, string);
        this.setBlitOffset(0);
        this.itemRenderer.field_4730 = 0.0f;
    }
}

