/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.ITrinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketSlots;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    public List<class_1799> oldStacks = new ArrayList<class_1799>();

    protected PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1542 method_7329(class_1799 var1, boolean var2, boolean var3);

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getEquippedStack(Lnet/minecraft/entity/EquipmentSlot;)Lnet/minecraft/item/ItemStack;"), method={"method_23668"})
    public class_1799 getEquippedStackProxy(class_1657 entity, class_1304 slot) {
        if (entity instanceof class_1657) {
            class_1657 player = entity;
            TrinketComponent comp = TrinketsApi.getTrinketComponent(player);
            return comp.getStack("chest", "cape");
        }
        return entity.method_6118(slot);
    }

    @Inject(at={@At(value="TAIL")}, method={"dropInventory"})
    protected void dropInventory(CallbackInfo info) {
        if (!this.field_6002.method_8450().method_8355(class_1928.field_19389)) {
            class_1263 inv = ((TrinketComponent)TrinketsApi.TRINKETS.get((Object)this)).getInventory();
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960()) continue;
                this.method_7329(stack, true, false);
            }
            inv.method_5448();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo info) {
        int i;
        if (this.field_6002.field_9236) {
            return;
        }
        class_1263 inv = TrinketsApi.getTrinketsInventory((class_1657)this);
        if (this.oldStacks.size() < inv.method_5439()) {
            for (i = this.oldStacks.size(); i < inv.method_5439(); ++i) {
                this.oldStacks.add(class_1799.field_8037);
            }
        }
        for (i = 0; i < inv.method_5439(); ++i) {
            class_1799 current;
            class_1799 old = this.oldStacks.get(i);
            if (old.method_7962(current = inv.method_5438(i))) continue;
            if (old.method_7909() instanceof ITrinket) {
                this.removeAttributes((class_1657)this, old, i);
            }
            if (current.method_7909() instanceof ITrinket) {
                this.addAttributes((class_1657)this, current, i);
            }
            this.oldStacks.set(i, current.method_7972());
        }
    }

    public void addAttributes(class_1657 player, class_1799 stack, int i) {
        if (stack.method_7909() instanceof ITrinket) {
            TrinketSlots.Slot slot = TrinketSlots.getAllSlots().get(i);
            TrinketSlots.SlotGroup group = slot.getSlotGroup();
            ITrinket trinket = (ITrinket)stack.method_7909();
            Multimap<String, class_1322> eams = trinket.getTrinketModifiers(group.getName(), slot.getName(), UUID.nameUUIDFromBytes((slot.getName() + ":" + group.getName()).getBytes()), stack);
            player.method_6127().method_6210(eams);
        }
    }

    public void removeAttributes(class_1657 player, class_1799 stack, int i) {
        if (stack.method_7909() instanceof ITrinket) {
            TrinketSlots.Slot slot = TrinketSlots.getAllSlots().get(i);
            TrinketSlots.SlotGroup group = slot.getSlotGroup();
            ITrinket trinket = (ITrinket)stack.method_7909();
            Multimap<String, class_1322> eams = trinket.getTrinketModifiers(group.getName(), slot.getName(), UUID.nameUUIDFromBytes((slot.getName() + ":" + group.getName()).getBytes()), stack);
            player.method_6127().method_6209(eams);
        }
    }
}

