/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui;

import de.sanandrew.mods.turretmod.inventory.ContainerElectrolyteGenerator;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteProcess;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPotatoGenerator
extends GuiContainer {
    private final TileEntityElectrolyteGenerator generator;
    private int currEnergy;
    private int maxEnergy;
    private float currEffective;
    private int generatedEnergy;

    public GuiPotatoGenerator(InventoryPlayer invPlayer, TileEntityElectrolyteGenerator tile) {
        super((Container)new ContainerElectrolyteGenerator((IInventory)invPlayer, tile));
        this.generator = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        IEnergyStorage stg = (IEnergyStorage)this.generator.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (stg != null) {
            this.currEnergy = stg.getEnergyStored();
            this.maxEnergy = stg.getMaxEnergyStored();
        }
        this.currEffective = this.generator.effectiveness;
        this.generatedEnergy = this.generator.getGeneratedFlux();
    }

    protected void func_146976_a(float partTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI_POTATOGEN.getResource());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        int max = this.generator.processes.length;
        for (int i = 0; i < max; ++i) {
            ElectrolyteProcess proc = this.generator.processes[i];
            if (proc == null) continue;
            this.func_73729_b(8 + i * 18, 61, 176, 59, 16 - (int)Math.round((double)((float)proc.getProgress() / (float)proc.maxProgress) * 16.0), 3);
        }
        double energyPerc = (double)this.currEnergy / (double)this.maxEnergy;
        int energyBarY = Math.max(0, Math.min(59, MathHelper.func_76143_f((double)((1.0 - energyPerc) * 59.0))));
        this.func_73729_b(156, 75 + energyBarY, 176, energyBarY, 12, 59 - energyBarY);
        GlStateManager.func_179121_F();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        String eff = String.format("%.2f%%", Float.valueOf(this.currEffective / 9.0f * 100.0f));
        this.field_146289_q.func_175065_a(Lang.translate(Lang.ELECTROGEN_EFFECTIVE.get(), new Object[0]), 8.0f, 100.0f, -10461088, false);
        this.field_146289_q.func_175065_a(eff, (float)(150 - this.field_146289_q.func_78256_a(eff)), 100.0f, -10461088, false);
        String rft = String.format("%d RF/t", this.generatedEnergy);
        this.field_146289_q.func_175065_a(Lang.translate(Lang.ELECTROGEN_POWERGEN.get(), new Object[0]), 8.0f, 110.0f, -10461088, false);
        this.field_146289_q.func_175065_a(rft, (float)(150 - this.field_146289_q.func_78256_a(rft)), 110.0f, -10461088, false);
        String s = this.generator.hasCustomName() ? this.generator.getName() : Lang.translate(this.generator.getName(), new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(Lang.translate(Lang.CONTAINER_INV.get(), new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (mouseX >= this.field_147003_i + 156 && mouseX < this.field_147003_i + 168 && mouseY >= this.field_147009_r + 75 && mouseY < this.field_147009_r + 134) {
            this.drawRFluxLabel(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        RenderHelper.func_74520_c();
    }

    private void drawRFluxLabel(int mouseX, int mouseY) {
        IEnergyStorage stg = (IEnergyStorage)this.generator.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        String amount = String.format("%d / %d RF", stg == null ? 0 : stg.getEnergyStored(), stg == null ? 0 : stg.getMaxEnergyStored());
        int textWidth = this.field_146289_q.func_78256_a(amount);
        int xPos = mouseX - 12 - textWidth;
        int yPos = mouseY - 12;
        int height = 7;
        int bkgColor = -267386864;
        int lightBg = 0x505000FF;
        int darkBg = (lightBg & 0xFEFEFE) >> 1 | lightBg & 0xFF000000;
        this.field_73735_i = 400.0f;
        this.func_73733_a(xPos - 3, yPos - 4, xPos + textWidth + 3, yPos - 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos + height + 3, xPos + textWidth + 3, yPos + height + 4, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos + textWidth + 3, yPos - 3, xPos + textWidth + 4, yPos + height + 3, bkgColor, bkgColor);
        this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + height + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos + textWidth + 2, yPos - 3 + 1, xPos + textWidth + 3, yPos + height + 3 - 1, lightBg, darkBg);
        this.func_73733_a(xPos - 3, yPos - 3, xPos + textWidth + 3, yPos - 3 + 1, lightBg, lightBg);
        this.func_73733_a(xPos - 3, yPos + height + 2, xPos + textWidth + 3, yPos + height + 3, darkBg, darkBg);
        this.field_73735_i = 0.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)0.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
        this.field_146289_q.func_78276_b(amount, 0, 0, -12632257);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.0f);
        this.field_146289_q.func_78276_b(amount, 0, 0, -1);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }
}

