/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.label;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.client.tcu.ILabelElement;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldTurret;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.TurretForcefield;
import de.sanandrew.mods.turretmod.util.Lang;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LabelTurretShield
implements ILabelElement {
    @Override
    public boolean showElement(ITurretInst turretInst) {
        return turretInst.getTurret() instanceof TurretForcefield;
    }

    @Override
    public float getHeight(ITurretInst turretInst, FontRenderer stdFontRenderer) {
        return (float)stdFontRenderer.field_78288_b + 6.0f;
    }

    @Override
    public float getWidth(ITurretInst turretInst, FontRenderer stdFontRenderer) {
        return stdFontRenderer.func_78256_a(LabelTurretShield.getLabel(turretInst));
    }

    @Override
    public void doRenderQuads(ITurretInst turretInst, float maxWidth, float progress, FontRenderer stdFontRenderer, float currHeight, VertexBuffer tessBuffer) {
        ShieldTurret shield = (ShieldTurret)turretInst.getRAM(null);
        float shieldPerc = shield == null ? 0.0f : shield.getValue() / shield.getMaxValue() * maxWidth;
        LabelTurretShield.addQuad(tessBuffer, 0.0, currHeight += (float)stdFontRenderer.field_78288_b + 2.0f, shieldPerc, (double)currHeight + 2.0, new ColorObj(1.0f, 1.0f, 0.0f, Math.max(progress, 0.015686275f)));
        LabelTurretShield.addQuad(tessBuffer, shieldPerc, currHeight, maxWidth, (double)currHeight + 2.0, new ColorObj(0.4f, 0.4f, 0.0f, Math.max(progress, 0.015686275f)));
    }

    @Override
    public void doRenderTextured(ITurretInst turretInst, float maxWidth, float progress, FontRenderer stdFontRenderer) {
        stdFontRenderer.func_175065_a(LabelTurretShield.getLabel(turretInst), 0.0f, 0.0f, new ColorObj(1.0f, 1.0f, 0.0f, Math.max(progress, 0.015686275f)).getColorInt(), false);
    }

    private static String getLabel(ITurretInst turretInst) {
        ShieldTurret shield = (ShieldTurret)turretInst.getRAM(null);
        if (shield != null) {
            if (shield.isInRecovery()) {
                return Lang.translate(Lang.TCU_LABEL_TURRETSHIELD_RECV, String.format("%.0f %%", Float.valueOf(shield.getRecovery() * 100.0f)));
            }
            return Lang.translate(Lang.TCU_LABEL_TURRETSHIELD, String.format("%.2f/%.2f", Float.valueOf(shield.getValue()), Float.valueOf(shield.getMaxValue())));
        }
        return "";
    }

    private static void addQuad(VertexBuffer buf, double minX, double minY, double maxX, double maxY, ColorObj clr) {
        buf.func_181662_b(minX, minY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(minX, maxY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, maxY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, minY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
    }
}

