/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.page;

import com.google.common.base.Strings;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTCU;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.gui.control.GuiButtonIcon;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncUpgradeInst;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.smartTargeting.AdvTargetSettings;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.io.IOException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSmartTargets
implements IGuiTCU {
    private GuiButton turretIgnore;
    private GuiButton turretCheckSame;
    private GuiButton turretCheckAll;
    private GuiButton tamedAll;
    private GuiButton tamedPlayers;
    private GuiButton tamedNone;
    private GuiButton childOnly;
    private GuiButton adultOnly;
    private GuiButton childAndAdult;
    private GuiButton noCount;
    private GuiButton countGlobalLess;
    private GuiButton countGlobalMore;
    private GuiButton countIndivLess;
    private GuiButton countIndivMore;
    private GuiTextField countEntities;

    @Override
    public void initGui(IGuiTcuInst<?> gui) {
        AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
        if (settings != null) {
            ResourceLocation texture = Resources.GUI_TCU_SMARTTGT.getResource();
            this.turretIgnore = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 10, gui.getPosY() + 48, 212, 18, texture, Lang.translate(Lang.TCU_BTN.get("adv_turret_ignore"), new Object[0])));
            this.turretCheckSame = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 29, gui.getPosY() + 48, 176, 18, texture, Lang.translate(Lang.TCU_BTN.get("adv_turret_same"), new Object[0])));
            this.turretCheckAll = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 48, gui.getPosY() + 48, 194, 18, texture, Lang.translate(Lang.TCU_BTN.get("adv_turret_all"), new Object[0])));
            this.tamedAll = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 10, gui.getPosY() + 82, 194, 72, texture, Lang.translate(Lang.TCU_BTN.get("adv_tamed_all"), new Object[0])));
            this.tamedPlayers = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 29, gui.getPosY() + 82, 176, 72, texture, Lang.translate(Lang.TCU_BTN.get("adv_tamed_players"), new Object[0])));
            this.tamedNone = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 48, gui.getPosY() + 82, 230, 18, texture, Lang.translate(Lang.TCU_BTN.get("adv_tamed_none"), new Object[0])));
            this.childAndAdult = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 10, gui.getPosY() + 116, 176, 126, texture, Lang.translate(Lang.TCU_BTN.get("adv_child_adult"), new Object[0])));
            this.childOnly = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 29, gui.getPosY() + 116, 212, 72, texture, Lang.translate(Lang.TCU_BTN.get("adv_child_only"), new Object[0])));
            this.adultOnly = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 48, gui.getPosY() + 116, 230, 72, texture, Lang.translate(Lang.TCU_BTN.get("adv_adult_only"), new Object[0])));
            this.noCount = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 10, gui.getPosY() + 150, 194, 126, texture, Lang.translate(Lang.TCU_BTN.get("adv_count_no"), new Object[0])));
            this.countGlobalLess = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 29, gui.getPosY() + 150, 212, 126, texture, Lang.translate(Lang.TCU_BTN.get("adv_count_global_less"), new Object[0])));
            this.countGlobalMore = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 48, gui.getPosY() + 150, 230, 126, texture, Lang.translate(Lang.TCU_BTN.get("adv_count_global_more"), new Object[0])));
            this.countIndivLess = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 67, gui.getPosY() + 150, 176, 180, texture, Lang.translate(Lang.TCU_BTN.get("adv_count_individual_less"), new Object[0])));
            this.countIndivMore = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 86, gui.getPosY() + 150, 194, 180, texture, Lang.translate(Lang.TCU_BTN.get("adv_count_individual_more"), new Object[0])));
            this.countEntities = new GuiTextField(0, gui.getFontRenderer(), gui.getPosX() + 110, gui.getPosY() + 157, 25, 10);
            this.countEntities.func_146203_f(3);
            this.countEntities.func_175205_a(s -> {
                if (Strings.isNullOrEmpty((String)s)) {
                    return true;
                }
                Integer val = GuiSmartTargets.getInteger(s, -1);
                return val >= 0 && val <= 256;
            });
            this.countEntities.func_146180_a(String.format("%d", settings.getCountEntities()));
        }
    }

    @Override
    public void updateScreen(IGuiTcuInst<?> gui) {
        AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
        if (settings != null) {
            this.turretIgnore.field_146124_l = settings.getTurretAwareness() != AdvTargetSettings.TurretAwareness.UNAWARE;
            this.turretCheckSame.field_146124_l = settings.getTurretAwareness() != AdvTargetSettings.TurretAwareness.SAME_TYPE;
            this.turretCheckAll.field_146124_l = settings.getTurretAwareness() != AdvTargetSettings.TurretAwareness.ALL_TYPES;
            this.tamedAll.field_146124_l = settings.getTamedAwareness() != AdvTargetSettings.TamedAwareness.UNAWARE;
            this.tamedPlayers.field_146124_l = settings.getTamedAwareness() != AdvTargetSettings.TamedAwareness.IGNORE_UNTARGETED_PLAYERS;
            this.tamedNone.field_146124_l = settings.getTamedAwareness() != AdvTargetSettings.TamedAwareness.IGNORE_ALL_TAMED;
            this.childAndAdult.field_146124_l = settings.getChildAwareness() != AdvTargetSettings.ChildAwareness.UNAWARE;
            this.childOnly.field_146124_l = settings.getChildAwareness() != AdvTargetSettings.ChildAwareness.CHILDREN_ONLY;
            this.adultOnly.field_146124_l = settings.getChildAwareness() != AdvTargetSettings.ChildAwareness.ADULTS_ONLY;
            this.noCount.field_146124_l = settings.getCountAwareness() != AdvTargetSettings.CountAwareness.NO_COUNT;
            this.countGlobalLess.field_146124_l = settings.getCountAwareness() != AdvTargetSettings.CountAwareness.IGNORE_IF_BELOW_GLOBAL;
            this.countGlobalMore.field_146124_l = settings.getCountAwareness() != AdvTargetSettings.CountAwareness.IGNORE_IF_ABOVE_GLOBAL;
            this.countIndivLess.field_146124_l = settings.getCountAwareness() != AdvTargetSettings.CountAwareness.IGNORE_IF_BELOW_INDIVIDUAL;
            this.countIndivMore.field_146124_l = settings.getCountAwareness() != AdvTargetSettings.CountAwareness.IGNORE_IF_ABOVE_INDIVIDUAL;
            this.countEntities.func_146184_c(this.noCount.field_146124_l);
            this.countEntities.func_146178_a();
        }
    }

    @Override
    public void drawBackground(IGuiTcuInst<?> gui, float partialTicks, int mouseX, int mouseY) {
        ((GuiScreen)gui.getGui()).field_146297_k.field_71446_o.func_110577_a(Resources.GUI_TCU_SMARTTGT.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.getGui().func_73729_b(gui.getPosX(), gui.getPosY(), 0, 0, gui.getWidth(), gui.getHeight());
        GuiSmartTargets.drawGroupBox(gui.getFontRenderer(), Lang.translate(Lang.TCU_SMARTTGT_GBOX.get("turret"), new Object[0]), gui.getPosX() + 7, gui.getPosY() + 39, 162, 30, Integer.MIN_VALUE, 0x30000000);
        GuiSmartTargets.drawGroupBox(gui.getFontRenderer(), Lang.translate(Lang.TCU_SMARTTGT_GBOX.get("tamed"), new Object[0]), gui.getPosX() + 7, gui.getPosY() + 73, 162, 30, Integer.MIN_VALUE, 0x30000000);
        GuiSmartTargets.drawGroupBox(gui.getFontRenderer(), Lang.translate(Lang.TCU_SMARTTGT_GBOX.get("age"), new Object[0]), gui.getPosX() + 7, gui.getPosY() + 107, 162, 30, Integer.MIN_VALUE, 0x30000000);
        GuiSmartTargets.drawGroupBox(gui.getFontRenderer(), Lang.translate(Lang.TCU_SMARTTGT_GBOX.get("count"), new Object[0]), gui.getPosX() + 7, gui.getPosY() + 141, 162, 30, Integer.MIN_VALUE, 0x30000000);
        if (this.countEntities != null) {
            this.countEntities.func_146194_f();
        }
    }

    @Override
    public void onButtonClick(IGuiTcuInst<?> gui, GuiButton button) throws IOException {
        AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
        if (settings != null) {
            if (button == this.turretIgnore) {
                settings.setTurretAwareness(AdvTargetSettings.TurretAwareness.UNAWARE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.turretCheckSame) {
                settings.setTurretAwareness(AdvTargetSettings.TurretAwareness.SAME_TYPE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.turretCheckAll) {
                settings.setTurretAwareness(AdvTargetSettings.TurretAwareness.ALL_TYPES);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.tamedAll) {
                settings.setTamedAwareness(AdvTargetSettings.TamedAwareness.UNAWARE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.tamedPlayers) {
                settings.setTamedAwareness(AdvTargetSettings.TamedAwareness.IGNORE_UNTARGETED_PLAYERS);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.tamedNone) {
                settings.setTamedAwareness(AdvTargetSettings.TamedAwareness.IGNORE_ALL_TAMED);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.childAndAdult) {
                settings.setChildAwareness(AdvTargetSettings.ChildAwareness.UNAWARE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.childOnly) {
                settings.setChildAwareness(AdvTargetSettings.ChildAwareness.CHILDREN_ONLY);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.adultOnly) {
                settings.setChildAwareness(AdvTargetSettings.ChildAwareness.ADULTS_ONLY);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.noCount) {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.NO_COUNT);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.countGlobalLess) {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.IGNORE_IF_BELOW_GLOBAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.countGlobalMore) {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.IGNORE_IF_ABOVE_GLOBAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.countIndivLess) {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.IGNORE_IF_BELOW_INDIVIDUAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            } else if (button == this.countIndivMore) {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.IGNORE_IF_ABOVE_INDIVIDUAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            }
        }
    }

    @Override
    public void onMouseClick(IGuiTcuInst<?> gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        this.countEntities.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean doKeyIntercept(IGuiTcuInst<?> gui, char typedChar, int keyCode) throws IOException {
        if (this.countEntities.func_146201_a(typedChar, keyCode)) {
            Integer val;
            AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
            if (settings != null && (val = GuiSmartTargets.getInteger(this.countEntities.func_146179_b(), null)) != null) {
                settings.setCountEntities(val);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            }
            return true;
        }
        return false;
    }

    private static void drawGroupBox(FontRenderer fontRenderer, String title, int x, int y, int width, int height, int textColor, int frameColor) {
        int strWidth = fontRenderer.func_78256_a(title);
        GlStateManager.func_179147_l();
        fontRenderer.func_175065_a(title, (float)(x + 5), (float)y, textColor, false);
        Gui.func_73734_a((int)x, (int)(y + 4), (int)(x + 3), (int)(y + 5), (int)frameColor);
        Gui.func_73734_a((int)(x + strWidth + 6), (int)(y + 4), (int)(x + width), (int)(y + 5), (int)frameColor);
        Gui.func_73734_a((int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)frameColor);
        Gui.func_73734_a((int)x, (int)(y + 5), (int)(x + 1), (int)(y + height - 1), (int)frameColor);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 5), (int)(x + width), (int)(y + height - 1), (int)frameColor);
    }

    public static boolean showTab(IGuiTcuInst<?> gui) {
        return gui.hasPermision() && gui.getTurretInst().getUpgradeProcessor().hasUpgrade(Upgrades.SMART_TGT);
    }

    private static AdvTargetSettings getSettings(IGuiTcuInst<?> gui) {
        AdvTargetSettings settings = (AdvTargetSettings)gui.getTurretInst().getUpgradeProcessor().getUpgradeInstance(Upgrades.SMART_TGT);
        if (settings == null) {
            ((GuiScreen)gui.getGui()).field_146297_k.field_71439_g.func_71053_j();
        }
        return settings;
    }

    private static void syncSettings(ITurretInst turretInst) {
        PacketRegistry.sendToServer((IMessage)new PacketSyncUpgradeInst(turretInst, Upgrades.SMART_TGT));
    }

    private static Integer getInteger(String s, Integer def) {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }
}

