/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.page;

import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.gui.control.GuiButtonIcon;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiTargets;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.io.IOException;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTargetCreatures
extends GuiTargets<Class<? extends Entity>> {
    private GuiButton selectMobs;
    private GuiButton selectAnimals;
    private GuiButton selectOther;

    @Override
    public void initGui(IGuiTcuInst<?> gui) {
        super.initGui(gui);
        int x = gui.getPosX() + gui.getWidth();
        int y = gui.getPosY() + 190;
        this.selectMobs = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), x - 63, y, 202, 36, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("select_mobs"), new Object[0])));
        this.selectAnimals = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), x - 44, y, 220, 36, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("select_animals"), new Object[0])));
        this.selectOther = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), x - 25, y, 238, 36, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("select_other"), new Object[0])));
    }

    @Override
    public void onButtonClick(IGuiTcuInst<?> gui, GuiButton button) throws IOException {
        super.onButtonClick(gui, button);
        if (button == this.selectMobs) {
            this.tempTargets.forEach((key, val) -> {
                if (!val.booleanValue() && IMob.class.isAssignableFrom((Class<?>)key)) {
                    this.updateEntry(gui.getTurretInst(), (Class<? extends Entity>)key, true);
                }
            });
            this.updateTargets(gui.getTurretInst());
        } else if (button == this.selectAnimals) {
            this.tempTargets.forEach((key, val) -> {
                if (!val.booleanValue() && IAnimals.class.isAssignableFrom((Class<?>)key) && !IMob.class.isAssignableFrom((Class<?>)key)) {
                    this.updateEntry(gui.getTurretInst(), (Class<? extends Entity>)key, true);
                }
            });
            this.updateTargets(gui.getTurretInst());
        } else if (button == this.selectOther) {
            this.tempTargets.forEach((key, val) -> {
                if (!(val.booleanValue() || IAnimals.class.isAssignableFrom((Class<?>)key) || IMob.class.isAssignableFrom((Class<?>)key))) {
                    this.updateEntry(gui.getTurretInst(), (Class<? extends Entity>)key, true);
                }
            });
            this.updateTargets(gui.getTurretInst());
        }
    }

    @Override
    protected SortedMap<Class<? extends Entity>, Boolean> getTargetList(ITurretInst turretInst) {
        TreeMap<Class<? extends Entity>, Boolean> btwSortMapCl = new TreeMap<Class<? extends Entity>, Boolean>(new TargetComparator());
        btwSortMapCl.putAll(turretInst.getTargetProcessor().getEntityTargets());
        return btwSortMapCl;
    }

    @Override
    protected void updateEntry(ITurretInst turretInst, Class<? extends Entity> type, boolean active) {
        turretInst.getTargetProcessor().updateEntityTarget(type, active);
    }

    @Override
    protected boolean isEntryVisible(Class<? extends Entity> type, String srcText) {
        return Lang.translateEntityCls(type).toUpperCase().contains(srcText.toUpperCase());
    }

    @Override
    protected void drawEntry(IGuiTcuInst<?> gui, Class<? extends Entity> type, int posX, int posY) {
        int textColor = -16777216;
        if (IMob.class.isAssignableFrom(type)) {
            textColor = -6291456;
        } else if (IAnimals.class.isAssignableFrom(type)) {
            textColor = -16736256;
        }
        gui.getFontRenderer().func_175065_a(Lang.translateEntityCls(type), (float)posX, (float)posY, textColor, false);
    }

    @Override
    protected boolean isBlacklist(ITurretInst turretInst) {
        return turretInst.getTargetProcessor().isEntityBlacklist();
    }

    @Override
    protected void setBlacklist(ITurretInst turretInst, boolean isBlacklist) {
        turretInst.getTargetProcessor().setEntityBlacklist(isBlacklist);
    }

    private static final class TargetComparator
    implements Comparator<Class<? extends Entity>> {
        private TargetComparator() {
        }

        @Override
        public int compare(Class<? extends Entity> o1, Class<? extends Entity> o2) {
            if (IMob.class.isAssignableFrom(o1)) {
                if (IMob.class.isAssignableFrom(o2)) {
                    return Lang.translateEntityCls(o1).compareTo(Lang.translateEntityCls(o2));
                }
                return -1;
            }
            if (IAnimals.class.isAssignableFrom(o1)) {
                if (IMob.class.isAssignableFrom(o2)) {
                    return 1;
                }
                if (IAnimals.class.isAssignableFrom(o2)) {
                    return Lang.translateEntityCls(o1).compareTo(Lang.translateEntityCls(o2));
                }
                return -1;
            }
            if (IMob.class.isAssignableFrom(o2) || IAnimals.class.isAssignableFrom(o2)) {
                return 1;
            }
            return Lang.translateEntityCls(o1).compareTo(Lang.translateEntityCls(o2));
        }
    }
}

