/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.client.turretinfo.IGuiTurretInfo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryMiscCraftable;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TurretInfoEntryGenerator
extends TurretInfoEntryMiscCraftable {
    private int drawHeight;
    private List<ItemStack> fuelItems;
    private ItemStack tooltipItem;

    public TurretInfoEntryGenerator(IRecipe recipe) {
        super(recipe);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, int scrollY, float partTicks) {
        super.drawPage(mouseX, mouseY, scrollY, partTicks);
        this.drawHeight = super.getPageHeight() + 3;
        Gui.func_73734_a((int)2, (int)this.drawHeight, (int)166, (int)(this.drawHeight + 1), (int)-16744261);
        this.drawHeight += 3;
        int maxItems = 9;
        this.tooltipItem = ItemStackUtils.getEmpty();
        int cnt = this.fuelItems.size();
        for (int i = 0; i < cnt; ++i) {
            int x = i % maxItems;
            int y = i / maxItems;
            this.drawFuelItem(3 + 18 * x, this.drawHeight + 18 * y, mouseX, mouseY, scrollY, this.fuelItems.get(i));
        }
        if (ItemStackUtils.isValid((ItemStack)this.tooltipItem)) {
            this.drawTooltipFuel(this.guiInfo.__getMc(), scrollY);
        }
        this.drawHeight += this.fuelItems.size() / maxItems * 18 + 20 + 48;
    }

    private void drawTooltipFuel(Minecraft mc, int scrollY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(135 + scrollY), (float)100.0f);
        Gui.func_73734_a((int)0, (int)0, (int)168, (int)48, (int)-805306368);
        mc.field_71466_p.func_175065_a(String.format("\u00c2\u00a7e%s", GuiUtils.getTooltipWithoutShift((ItemStack)this.tooltipItem).get(0)), 22.0f, 2.0f, -1, false);
        ElectrolyteRegistry.Fuel fuel = ElectrolyteRegistry.getFuel(this.tooltipItem);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_EFFICIENCY.get(), Float.valueOf(fuel.effect)), 22.0f, 11.0f, -1, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_DECAY.get(), MiscUtils.getTimeFromTicks((int)fuel.ticksProc)), 22.0f, 20.0f, -1, false);
        mc.field_71466_p.func_175065_a(String.format("\u00c2\u00a7a%s", GuiUtils.getTooltipWithoutShift((ItemStack)fuel.trash).get(0)), 32.0f, 29.0f, -1, false);
        mc.field_71466_p.func_175065_a(String.format("\u00c2\u00a7d%s", GuiUtils.getTooltipWithoutShift((ItemStack)fuel.treasure).get(0)), 32.0f, 38.0f, -1, false);
        RenderUtils.renderStackInGui((ItemStack)this.tooltipItem, (int)2, (int)12, (double)1.0, (FontRenderer)mc.field_71466_p);
        RenderUtils.renderStackInGui((ItemStack)fuel.trash, (int)22, (int)28, (double)0.5);
        RenderUtils.renderStackInGui((ItemStack)fuel.treasure, (int)22, (int)37, (double)0.5);
        GlStateManager.func_179121_F();
    }

    private void drawFuelItem(int x, int y, int mouseX, int mouseY, int scrollY, ItemStack stack) {
        boolean mouseOver;
        this.guiInfo.__getMc().func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiInfo.__drawTexturedRect(x, y, 192, 0, 18, 18);
        GlStateManager.func_179094_E();
        boolean bl = mouseOver = mouseY >= 0 && mouseY < 183 && mouseX >= x && mouseX < x + 18 && mouseY >= y - scrollY && mouseY < y + 18 - scrollY;
        if (mouseOver) {
            this.tooltipItem = stack;
        }
        GlStateManager.func_179109_b((float)x, (float)y, (float)32.0f);
        RenderUtils.renderStackInGui((ItemStack)stack, (int)1, (int)1, (double)1.0, (FontRenderer)this.guiInfo.__getMc().field_71466_p);
        if (mouseOver) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)64.0f);
            Gui.func_73734_a((int)1, (int)1, (int)17, (int)17, (int)-2130706433);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void initEntry(IGuiTurretInfo gui) {
        super.initEntry(gui);
        Set<ItemStack> fuelList = ElectrolyteRegistry.getFuelMap().keySet();
        this.fuelItems = new ArrayList<ItemStack>(fuelList.size());
        this.fuelItems.addAll(fuelList);
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }
}

