/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.assembly.IRecipeEntry;
import de.sanandrew.mods.turretmod.api.client.turretinfo.IGuiTurretInfo;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoEntry;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TurretInfoEntryTurret
implements ITurretInfoEntry {
    private int drawHeight;
    private float rotation;
    private long lastTimestamp;
    private WeakReference<EntityTurret> turretRenderCache;
    private IGuiTurretInfo guiInfo;
    private final ItemStack icon;
    private final ITurret turret;
    private final TurretInfoValues values;

    public TurretInfoEntryTurret(ITurret turret) {
        this.values = new TurretInfoValues(turret);
        this.turret = turret;
        this.icon = TurretRegistry.INSTANCE.getTurretItem(turret);
    }

    @Override
    public void initEntry(IGuiTurretInfo gui) {
        this.guiInfo = gui;
    }

    @Override
    public String getTitle() {
        return Lang.TURRET_NAME.get(this.values.name);
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public void drawPage(int mouseX, int mouseY, int scrollY, float partTicks) {
        int i;
        int turretHeight = 82;
        int valueHeight = 113;
        Minecraft mc = this.guiInfo.__getMc();
        mc.field_71466_p.func_78276_b(TextFormatting.ITALIC + Lang.translate(this.getTitle(), new Object[0]), 2, 2, -16744261);
        Gui.func_73734_a((int)2, (int)12, (int)166, (int)13, (int)-16744261);
        this.guiInfo.doEntryScissoring(2, 15, 54, 82);
        Gui.func_73734_a((int)0, (int)0, (int)168, (int)183, (int)-16777216);
        this.drawTurret(mc, 28, 35);
        this.guiInfo.doEntryScissoring();
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_HEALTH.get(), new Object[0]), 60.0f, 15.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_HEALTHVAL.get(), Float.valueOf(this.values.health)), 63.0f, 24.0f, -16777216, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_RANGE.get(), new Object[0]), 60.0f, 35.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_RANGEVAL.get(), this.values.range), 63.0f, 44.0f, -16777216, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_AMMOCAP.get(), new Object[0]), 60.0f, 55.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_ROUNDSVAL.get(), this.values.ammoCap), 63.0f, 64.0f, -16777216, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_AMMOUSE.get(), new Object[0]), 60.0f, 75.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_CRAFTING.get(), new Object[0]), 60.0f, 95.0f, -9803158, false);
        int descStart = Math.max(turretHeight, valueHeight);
        String desc = Lang.translate(Lang.TURRET_DESC.get(this.values.name), new Object[0]).replace("\\n", "\n");
        Gui.func_73734_a((int)2, (int)(2 + descStart), (int)166, (int)(3 + descStart), (int)-16744261);
        mc.field_71466_p.func_78279_b(desc, 2, 5 + descStart, 166, -16777216);
        int descHeight = mc.field_71466_p.func_78267_b(desc, 164) + 7;
        for (i = 0; i < this.values.ammoStacks.length; ++i) {
            this.guiInfo.drawMiniItem(63 + 10 * i, 84, mouseX, mouseY, scrollY, this.values.ammoStacks[i], true);
        }
        for (i = 0; i < this.values.recipeStacks.length; ++i) {
            this.drawItemRecipe(63 + 10 * i, 104, mouseX, mouseY, scrollY, this.values.recipeStacks[i]);
        }
        this.drawHeight = descStart + descHeight;
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }

    private void drawTurret(Minecraft mc, int x, int y) {
        EntityTurret turret;
        if (this.turretRenderCache == null || this.turretRenderCache.get() == null || this.turretRenderCache.isEnqueued()) {
            try {
                this.turretRenderCache = new WeakReference<EntityTurret>(new EntityTurret((World)mc.field_71441_e, this.turret));
            }
            catch (Exception e) {
                return;
            }
        }
        if ((turret = (EntityTurret)this.turretRenderCache.get()) == null) {
            return;
        }
        turret.inGui = true;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)30.0f, (float)30.0f, (float)30.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)turret.field_70131_O, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(135.0f + this.rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.rotation += 0.2f;
        turret.field_70125_A = 0.0f;
        turret.field_70127_C = 0.0f;
        turret.field_70177_z = 0.0f;
        turret.field_70126_B = 0.0f;
        turret.field_70759_as = 0.0f;
        turret.field_70758_at = 0.0f;
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)turret, 0.0, 0.0, 0.0, 0.0f, 1.0f, true);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawItemRecipe(int x, int y, int mouseX, int mouseY, int scrollY, IRecipeEntry entryItem) {
        ItemStack[] entryStacks = entryItem.getEntryItemStacks();
        ItemStack stack = entryStacks[(int)(this.lastTimestamp / 1000L % (long)entryStacks.length)];
        this.guiInfo.drawMiniItem(x, y, mouseX, mouseY, scrollY, stack, entryItem.shouldDrawTooltip());
    }

    private static final class TurretInfoValues {
        public final String name;
        public final float health;
        public final int ammoCap;
        public final String range;
        public final IRecipeEntry[] recipeStacks;
        public final ItemStack[] ammoStacks;

        public TurretInfoValues(ITurret turret) {
            ArrayList<ItemStack> ammoItms = new ArrayList<ItemStack>();
            this.name = turret.getName();
            this.range = turret.getInfo().getRange();
            this.health = turret.getInfo().getHealth();
            this.ammoCap = turret.getInfo().getAmmoCapacity();
            List<IAmmunition> ammos = AmmunitionRegistry.INSTANCE.getTypesForTurret(turret);
            for (IAmmunition ammo : ammos) {
                ammoItms.add(AmmunitionRegistry.INSTANCE.getAmmoItem(ammo));
            }
            TurretAssemblyRegistry.RecipeEntry recipeEntry = TurretAssemblyRegistry.INSTANCE.getRecipeEntry(TurretRegistry.INSTANCE.getTurretItem(turret));
            this.recipeStacks = recipeEntry == null ? new IRecipeEntry[]{} : recipeEntry.resources;
            this.ammoStacks = ammoItms.toArray(new ItemStack[ammoItms.size()]);
        }
    }
}

