/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.turretmod.api.client.turretinfo.IGuiTurretInfo;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoEntry;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TurretInfoEntryUpgrade
implements ITurretInfoEntry {
    private int drawHeight;
    private long lastTimestamp;
    private IGuiTurretInfo guiInfo;
    private final ItemStack icon;
    private final String title;
    private final ITurretUpgrade upgrade;

    public TurretInfoEntryUpgrade(ITurretUpgrade upgrade) {
        this.upgrade = upgrade;
        this.icon = UpgradeRegistry.INSTANCE.getUpgradeItem(this.upgrade);
        this.title = this.upgrade.getName();
    }

    @Override
    public void initEntry(IGuiTurretInfo gui) {
        this.guiInfo = gui;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public String getTitle() {
        return Lang.ITEM_UPGRADE_NAME.get(this.title);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, int scrollY, float partTicks) {
        long time;
        ITurretUpgrade prereq = this.upgrade.getDependantOn();
        int infoHeight = 54;
        Minecraft mc = this.guiInfo.__getMc();
        ItemStack upgStack = UpgradeRegistry.INSTANCE.getUpgradeItem(this.upgrade);
        mc.field_71466_p.func_78276_b(TextFormatting.ITALIC + Lang.translate(this.getTitle(), new Object[0]), 2, 2, -16744261);
        Gui.func_73734_a((int)2, (int)12, (int)166, (int)13, (int)-16744261);
        mc.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiInfo.__drawTexturedRect(2, 16, 192, 18, 34, 34);
        RenderUtils.renderStackInGui((ItemStack)upgStack, (int)3, (int)17, (double)2.0);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_CRAFTING.get(), new Object[0]), 42.0f, 16.0f, -9803158, false);
        if (prereq != null) {
            mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_PREREQ.get(), new Object[0]), 42.0f, 36.0f, -9803158, false);
            infoHeight = 56;
        }
        Gui.func_73734_a((int)2, (int)infoHeight, (int)166, (int)(infoHeight + 1), (int)-16744261);
        String text = Lang.translate(String.format(Lang.ITEM_UPGRADE_DESC.get(), this.upgrade.getName()), new Object[0]).replace("\\n", "\n");
        mc.field_71466_p.func_78279_b(text, 2, infoHeight + 3, 166, -16777216);
        this.drawHeight = mc.field_71466_p.func_78267_b(text, 166) + infoHeight + 3 + 2;
        TurretAssemblyRegistry.RecipeEntry recipeEntry = TurretAssemblyRegistry.INSTANCE.getRecipeEntry(upgStack);
        if (recipeEntry != null) {
            for (int i = 0; i < recipeEntry.resources.length; ++i) {
                ItemStack[] stacks = recipeEntry.resources[i].getEntryItemStacks();
                this.guiInfo.drawMiniItem(45 + 10 * i, 25, mouseX, mouseY, scrollY, stacks[(int)(this.lastTimestamp / 1000L % (long)stacks.length)], recipeEntry.resources[i].shouldDrawTooltip());
            }
        }
        if (prereq != null) {
            this.guiInfo.drawMiniItem(45, 45, mouseX, mouseY, scrollY, UpgradeRegistry.INSTANCE.getUpgradeItem(prereq), true);
        }
        if (this.lastTimestamp + 1000L < (time = System.currentTimeMillis())) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }
}

