/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.model;

import de.sanandrew.mods.sanlib.lib.client.ModelJsonLoader;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.model.ModelTurretBase;
import de.sanandrew.mods.turretmod.registry.turret.TurretShotgun;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class ModelTurretShotgun
extends ModelTurretBase {
    public ModelRenderer barrel;

    public ModelTurretShotgun(float scale) {
        super(scale);
    }

    @Override
    public List<String> getMandatoryBoxes() {
        return Stream.concat(super.getMandatoryBoxes().stream(), Stream.of("barrel")).collect(Collectors.toList());
    }

    @Override
    public ResourceLocation getModelLocation() {
        return Resources.TURRET_T1_SHOTGUN_MODEL.getResource();
    }

    @Override
    public void onReload(IResourceManager iResourceManager, ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> loader) {
        super.onReload(iResourceManager, loader);
        this.barrel = loader.getBox("barrel");
    }

    public void func_78086_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partTicks) {
        super.func_78086_a(entity, limbSwing, limbSwingAmount, partTicks);
        ITurretInst turretInst = (ITurretInst)entity;
        if (turretInst.getTurret() instanceof TurretShotgun) {
            TurretShotgun.MyRAM ram = turretInst.getRAM(TurretShotgun.MyRAM::new);
            float barrelDelta = ram.prevBarrelPos + (ram.barrelPos - ram.prevBarrelPos) * partTicks;
            this.barrel.field_78798_e = 3.0f - 3.0f * barrelDelta;
        }
    }
}

